/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx;

import blue.orchestra.blueSynthBuilder.BSBDropdown;
import blue.orchestra.blueSynthBuilder.BSBDropdownItem;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.ChoiceBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.openide.util.Exceptions;

public class BSBDropdownView
extends ChoiceBox<BSBDropdownItem> {
    private final BSBDropdown dropdown;
    boolean mutating = false;

    public BSBDropdownView(BSBDropdown dropdown) {
        super(dropdown.dropdownItemsProperty());
        this.setUserData(dropdown);
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("bsbDropdown.css").toExternalForm());
        this.dropdown = dropdown;
        ChangeListener cl = (obs, old, newVal) -> {
            if (!this.mutating) {
                this.mutating = true;
                if (!Platform.isFxApplicationThread()) {
                    CountDownLatch latch = new CountDownLatch(1);
                    Platform.runLater(() -> {
                        try {
                            this.getSelectionModel().select(newVal.intValue());
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                    try {
                        latch.await();
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    this.getSelectionModel().select(newVal.intValue());
                }
                this.mutating = false;
            }
        };
        this.getSelectionModel().selectedIndexProperty().addListener((obs, o, newVal) -> {
            if (!this.mutating) {
                this.mutating = true;
                dropdown.setSelectedIndex(newVal.intValue());
                this.mutating = false;
            }
        });
        ChangeListener fontListener = (obs, old, newVal) -> this.updateFont(dropdown.getFontSize());
        InvalidationListener listListener = o -> this.updateWidth();
        this.sceneProperty().addListener((obs, old, newVal) -> {
            if (newVal == null) {
                dropdown.selectedIndexProperty().removeListener(cl);
                dropdown.fontSizeProperty().removeListener(fontListener);
                dropdown.getBSBDropdownItemList().removeListener(listListener);
            } else {
                this.getSelectionModel().select(dropdown.getSelectedIndex());
                dropdown.selectedIndexProperty().addListener(cl);
                dropdown.fontSizeProperty().addListener(fontListener);
                dropdown.getBSBDropdownItemList().addListener(listListener);
            }
        });
        this.updateFont(dropdown.getFontSize());
        this.updateWidth();
    }

    protected void updateFont(int fontSize) {
        this.setStyle(String.format("-fx-font-size: %dpx;", fontSize));
    }

    protected void updateWidth() {
        Font f = Font.font((String)"System Regular", (double)this.dropdown.getFontSize());
        Text t = new Text();
        t.setFont(f);
        double w = 0.0;
        for (BSBDropdownItem item : this.dropdown.getBSBDropdownItemList()) {
            t.setText(item.getName());
            w = Math.max(w, t.getLayoutBounds().getWidth());
        }
        this.setPrefWidth(w += 24.0);
        this.setWidth(w);
    }
}

