/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx;

import blue.orchestra.blueSynthBuilder.BSBVSlider;
import blue.orchestra.blueSynthBuilder.BSBVSliderBank;
import blue.orchestra.editor.blueSynthBuilder.jfx.BSBVSliderView;
import blue.orchestra.editor.blueSynthBuilder.jfx.ResizeableView;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.scene.layout.HBox;

public class BSBVSliderBankView
extends HBox
implements ResizeableView {
    BSBVSliderBank bsbVSliderBank;

    public BSBVSliderBankView(BSBVSliderBank sliderBank) {
        this.bsbVSliderBank = sliderBank;
        this.setUserData(sliderBank);
        List views = sliderBank.getSliders().stream().map(e -> new BSBVSliderView((BSBVSlider)e)).collect(Collectors.toList());
        this.getChildren().addAll(views);
        ListChangeListener lcl = c -> {
            while (c.next()) {
                if (c.wasPermutated() || c.wasUpdated()) continue;
                List removedItems = c.getRemoved();
                this.getChildren().removeIf(a -> removedItems.contains((BSBVSlider)a.getUserData()));
                this.getChildren().addAll((Collection)c.getAddedSubList().stream().map(a -> new BSBVSliderView((BSBVSlider)a)).collect(Collectors.toList()));
            }
        };
        this.sceneProperty().addListener((obs, old, newVal) -> {
            if (newVal == null) {
                this.spacingProperty().unbind();
                sliderBank.getSliders().removeListener(lcl);
            } else {
                this.spacingProperty().bind((ObservableValue)sliderBank.gapProperty());
                sliderBank.getSliders().addListener(lcl);
            }
        });
    }

    @Override
    public boolean canResizeWidgetWidth() {
        return false;
    }

    @Override
    public boolean canResizeWidgetHeight() {
        return true;
    }

    @Override
    public int getWidgetMinimumWidth() {
        return -1;
    }

    @Override
    public int getWidgetMinimumHeight() {
        int base = this.bsbVSliderBank.isValueDisplayEnabled() ? 30 : 0;
        return 45 + base;
    }

    @Override
    public int getWidgetWidth() {
        return -1;
    }

    @Override
    public void setWidgetWidth(int width) {
    }

    @Override
    public int getWidgetHeight() {
        int base = this.bsbVSliderBank.isValueDisplayEnabled() ? 30 : 0;
        return base + this.bsbVSliderBank.getSliderHeight();
    }

    @Override
    public void setWidgetHeight(int height) {
        int base = this.bsbVSliderBank.isValueDisplayEnabled() ? 30 : 0;
        this.bsbVSliderBank.setSliderHeight(Math.max(45, height - base));
    }

    @Override
    public void setWidgetX(int x) {
    }

    @Override
    public int getWidgetX() {
        return -1;
    }

    @Override
    public void setWidgetY(int y) {
        this.bsbVSliderBank.setY(y);
    }

    @Override
    public int getWidgetY() {
        return this.bsbVSliderBank.getY();
    }
}

