/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.jmask;

import blue.soundObject.editor.jmask.DurationSettable;
import blue.soundObject.editor.jmask.TableEditor;
import blue.soundObject.jmask.Quantizer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class QuantizerEditor
extends JPanel
implements DurationSettable {
    private Quantizer quantizer;
    private ButtonGroup gridSizeButtonGroup;
    private JSpinner gridSizeSpinner;
    private TableEditor gridSizeTableEditor;
    private JComboBox gridSizeTypeComboBox;
    private JLabel jLabel1;
    private ButtonGroup offsetButtonGroup;
    private JSpinner offsetSpinner;
    private TableEditor offsetTableEditor;
    private JComboBox offsetTypeComboBox;
    private ButtonGroup strengthButtonGroup;
    private JSpinner strengthSpinner;
    private TableEditor strengthTableEditor;
    private JComboBox strengthTypeComboBox;

    public QuantizerEditor(Quantizer quantizer) {
        this.initComponents();
        this.gridSizeTableEditor.setTable(quantizer.getGridSizeTable());
        this.strengthTableEditor.setTable(quantizer.getStrengthTable());
        this.strengthTableEditor.setMinMaxEnabled(false);
        this.offsetTableEditor.setTable(quantizer.getOffsetTable());
        this.gridSizeSpinner.setModel(new SpinnerNumberModel(quantizer.getGridSize(), Double.MIN_VALUE, Double.POSITIVE_INFINITY, 0.1));
        this.strengthSpinner.setModel(new SpinnerNumberModel(quantizer.getStrength(), 0.0, 1.0, 0.1));
        this.offsetSpinner.setModel(new SpinnerNumberModel(quantizer.getOffset(), 0.0, Double.POSITIVE_INFINITY, 0.1));
        this.gridSizeTypeComboBox.setSelectedIndex(quantizer.isGridSizeTableEnabled() ? 1 : 0);
        this.strengthTypeComboBox.setSelectedIndex(quantizer.isStrengthTableEnabled() ? 1 : 0);
        this.offsetTypeComboBox.setSelectedIndex(quantizer.isOffsetTableEnabled() ? 1 : 0);
        this.quantizer = quantizer;
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.gridSizeSpinner.setVisible(!this.quantizer.isGridSizeTableEnabled());
        this.gridSizeTableEditor.setVisible(this.quantizer.isGridSizeTableEnabled());
        this.strengthSpinner.setVisible(!this.quantizer.isStrengthTableEnabled());
        this.strengthTableEditor.setVisible(this.quantizer.isStrengthTableEnabled());
        this.offsetSpinner.setVisible(!this.quantizer.isOffsetTableEnabled());
        this.offsetTableEditor.setVisible(this.quantizer.isOffsetTableEnabled());
    }

    private void initComponents() {
        this.gridSizeButtonGroup = new ButtonGroup();
        this.strengthButtonGroup = new ButtonGroup();
        this.offsetButtonGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.gridSizeTableEditor = new TableEditor();
        this.strengthSpinner = new JSpinner();
        this.strengthTableEditor = new TableEditor();
        this.gridSizeSpinner = new JSpinner();
        this.offsetSpinner = new JSpinner();
        this.offsetTableEditor = new TableEditor();
        this.gridSizeTypeComboBox = new JComboBox();
        this.strengthTypeComboBox = new JComboBox();
        this.offsetTypeComboBox = new JComboBox();
        this.jLabel1.setText("Quantizer");
        this.strengthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                QuantizerEditor.this.strengthSpinnerStateChanged(evt);
            }
        });
        this.gridSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                QuantizerEditor.this.gridSizeSpinnerStateChanged(evt);
            }
        });
        this.offsetSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                QuantizerEditor.this.offsetSpinnerStateChanged(evt);
            }
        });
        this.gridSizeTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Grid Size (Constant)", "Grid Size (Table)"}));
        this.gridSizeTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QuantizerEditor.this.gridSizeTypeComboBoxActionPerformed(evt);
            }
        });
        this.strengthTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Strength (Constant)", "Strength (Table)"}));
        this.strengthTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QuantizerEditor.this.strengthTypeComboBoxActionPerformed(evt);
            }
        });
        this.offsetTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Offset (Constant)", "Offset (Table)"}));
        this.offsetTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QuantizerEditor.this.offsetTypeComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.strengthTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.strengthSpinner, -2, 84, -2)).addGroup(layout.createSequentialGroup().addComponent(this.gridSizeTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gridSizeSpinner, -2, 84, -2)).addComponent(this.jLabel1).addComponent(this.gridSizeTableEditor, -1, 846, Short.MAX_VALUE).addComponent(this.strengthTableEditor, -1, 846, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.offsetTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.offsetSpinner, -2, 84, -2)).addComponent(this.offsetTableEditor, -1, 846, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.gridSizeTypeComboBox, this.offsetTypeComboBox, this.strengthTypeComboBox);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.gridSizeSpinner, -2, -1, -2).addComponent(this.gridSizeTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gridSizeTableEditor, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.strengthTypeComboBox, -2, -1, -2).addComponent(this.strengthSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.strengthTableEditor, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.offsetTypeComboBox, -2, -1, -2).addComponent(this.offsetSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.offsetTableEditor, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void strengthSpinnerStateChanged(ChangeEvent evt) {
        if (this.quantizer != null) {
            this.quantizer.setStrength(((Double)this.strengthSpinner.getValue()).doubleValue());
        }
    }

    private void gridSizeSpinnerStateChanged(ChangeEvent evt) {
        if (this.quantizer != null) {
            this.quantizer.setGridSize(((Double)this.gridSizeSpinner.getValue()).doubleValue());
        }
    }

    private void offsetSpinnerStateChanged(ChangeEvent evt) {
        if (this.quantizer != null) {
            this.quantizer.setOffset(((Double)this.offsetSpinner.getValue()).doubleValue());
        }
    }

    private void gridSizeTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.quantizer != null) {
            this.quantizer.setGridSizeTableEnabled(this.gridSizeTypeComboBox.getSelectedIndex() == 1);
            this.updateDisplay();
        }
    }

    private void strengthTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.quantizer != null) {
            this.quantizer.setStrengthTableEnabled(this.strengthTypeComboBox.getSelectedIndex() == 1);
            this.updateDisplay();
        }
    }

    private void offsetTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.quantizer != null) {
            this.quantizer.setOffsetTableEnabled(this.offsetTypeComboBox.getSelectedIndex() == 1);
            this.updateDisplay();
        }
    }

    @Override
    public void setDuration(double duration) {
        this.gridSizeTableEditor.setDuration(duration);
        this.offsetTableEditor.setDuration(duration);
        this.strengthTableEditor.setDuration(duration);
    }
}

