/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.jmask.probability;

import blue.soundObject.editor.jmask.DurationSettable;
import blue.soundObject.editor.jmask.TableEditor;
import blue.soundObject.jmask.probability.Cauchy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CauchyEditor
extends JPanel
implements DurationSettable {
    private Cauchy cauchy = null;
    private ButtonGroup aButtonGroup;
    private JSpinner alphaSpinner;
    private TableEditor alphaTableEditor;
    private ButtonGroup bButtonGroup;
    private JComboBox meanTypeComboBox;
    private JSpinner muSpinner;
    private TableEditor muTableEditor;
    private JComboBox spreadTypeComboBox;

    public CauchyEditor(Cauchy cauchy) {
        this.initComponents();
        this.alphaTableEditor.setMinMaxEnabled(false);
        this.muTableEditor.setMinMaxEnabled(false);
        this.alphaTableEditor.setTable(cauchy.getAlphaTable());
        this.muTableEditor.setTable(cauchy.getMuTable());
        this.alphaSpinner.setModel(new SpinnerNumberModel(cauchy.getAlpha(), 0.0, 1.0, 0.1));
        this.muSpinner.setModel(new SpinnerNumberModel(cauchy.getMu(), 0.0, 1.0, 0.1));
        this.spreadTypeComboBox.setSelectedIndex(cauchy.isAlphaTableEnabled() ? 1 : 0);
        this.meanTypeComboBox.setSelectedIndex(cauchy.isMuTableEnabled() ? 1 : 0);
        this.cauchy = cauchy;
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.alphaSpinner.setVisible(!this.cauchy.isAlphaTableEnabled());
        this.alphaTableEditor.setVisible(this.cauchy.isAlphaTableEnabled());
        this.muSpinner.setVisible(!this.cauchy.isMuTableEnabled());
        this.muTableEditor.setVisible(this.cauchy.isMuTableEnabled());
    }

    private void initComponents() {
        this.aButtonGroup = new ButtonGroup();
        this.bButtonGroup = new ButtonGroup();
        this.alphaSpinner = new JSpinner();
        this.alphaTableEditor = new TableEditor();
        this.muSpinner = new JSpinner();
        this.muTableEditor = new TableEditor();
        this.spreadTypeComboBox = new JComboBox();
        this.meanTypeComboBox = new JComboBox();
        this.alphaSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CauchyEditor.this.alphaSpinnerStateChanged(evt);
            }
        });
        this.muSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CauchyEditor.this.muSpinnerStateChanged(evt);
            }
        });
        this.spreadTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Spread/alpha (Constant)", "Spread/alpha (Table)"}));
        this.spreadTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CauchyEditor.this.spreadTypeComboBoxActionPerformed(evt);
            }
        });
        this.meanTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Mean/mu (Constant)", "Mean/mu (Table)"}));
        this.meanTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CauchyEditor.this.meanTypeComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.spreadTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.alphaSpinner, -2, 84, -2)).addGroup(layout.createSequentialGroup().addComponent(this.meanTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.muSpinner, -2, 84, -2)).addComponent(this.alphaTableEditor, -2, 414, Short.MAX_VALUE).addComponent(this.muTableEditor, -2, 414, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.meanTypeComboBox, this.spreadTypeComboBox);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spreadTypeComboBox, -2, -1, -2).addComponent(this.alphaSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.alphaTableEditor, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.meanTypeComboBox, -2, -1, -2).addComponent(this.muSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.muTableEditor, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void alphaSpinnerStateChanged(ChangeEvent evt) {
        if (this.cauchy != null) {
            this.cauchy.setAlpha(((Double)this.alphaSpinner.getValue()).doubleValue());
        }
    }

    private void muSpinnerStateChanged(ChangeEvent evt) {
        if (this.cauchy != null) {
            this.cauchy.setMu(((Double)this.muSpinner.getValue()).doubleValue());
        }
    }

    private void spreadTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.cauchy != null) {
            this.cauchy.setAlphaTableEnabled(this.spreadTypeComboBox.getSelectedIndex() == 1);
            this.updateDisplay();
        }
    }

    private void meanTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.cauchy != null) {
            this.cauchy.setMuTableEnabled(this.meanTypeComboBox.getSelectedIndex() == 1);
            this.updateDisplay();
        }
    }

    @Override
    public void setDuration(double duration) {
        this.alphaTableEditor.setDuration(duration);
        this.muTableEditor.setDuration(duration);
    }
}

