/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.lineEditor;

import blue.BlueSystem;
import blue.automation.LineColors;
import blue.components.lines.Line;
import blue.components.lines.LineListTableModel;
import javax.swing.JOptionPane;

public class ZakLineListTableModel
extends LineListTableModel {
    @Override
    public void addLine(int index) {
        if (this.lines == null) {
            return;
        }
        Line line = new Line();
        line.setZak(true);
        line.setChannel(1);
        line.setColor(LineColors.getColor((int)this.lines.size()));
        if (index < 0 || index == this.lines.size() - 1) {
            this.lines.add((Object)line);
            int row = this.lines.size() - 1;
            this.fireTableRowsInserted(row, row);
        } else {
            this.lines.add(index, (Object)line);
            this.fireTableRowsInserted(index, index);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.lines == null) {
            return null;
        }
        if (columnIndex == 1) {
            Line line = (Line)this.lines.get(rowIndex);
            Integer tempChannel = new Integer(line.getChannel());
            return tempChannel.toString();
        }
        return super.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 1) {
            Line line = (Line)this.lines.get(row);
            String strChannel = (String)value;
            try {
                int tempChannel = Integer.parseInt(strChannel);
                if (tempChannel < 0) {
                    throw new NumberFormatException("Zak Channel numbers must be 0 or greater");
                }
                line.setChannel(tempChannel);
                this.fireTableCellUpdated(row, col);
            }
            catch (NumberFormatException e) {
                String errorMessage = BlueSystem.getString((String)"message.line.channelParseErr");
                JOptionPane.showMessageDialog(null, errorMessage, BlueSystem.getString((String)"message.line.badChannel"), 0);
            }
        } else {
            super.setValueAt(value, row, col);
        }
    }

    @Override
    public String getColumnName(int column) {
        if (column == 1) {
            return BlueSystem.getString((String)"lineObject.zakChannel");
        }
        return super.getColumnName(column);
    }
}

