/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.soundFont;

import blue.gui.FileTree;
import blue.gui.FileTreePopup;
import blue.tools.soundFont.InstrumentInfoTableModel;
import blue.tools.soundFont.PresetInfoTableModel;
import blue.tools.soundFont.SoundFontInfo;
import blue.tools.soundFont.SoundFontUtility;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

public class SoundFontViewer
extends JComponent {
    JTable instrumentInfo = new JTable(new InstrumentInfoTableModel());
    JTable presetInfo = new JTable(new PresetInfoTableModel());

    public SoundFontViewer() {
        this.setLayout(new BorderLayout());
        JSplitPane split = new JSplitPane();
        this.add((Component)split, "Center");
        FileTree fTree = new FileTree();
        fTree.setMinimumSize(new Dimension(0, 0));
        String[] filters = new String[]{".sf2"};
        fTree.setFilters(filters);
        fTree.addFileTreeListener(this::getSoundFontInfo);
        fTree.addFileTreePopup(new SFFileTreePopup());
        JTabbedPane tabs = new JTabbedPane();
        JScrollPane scrollInstrument = new JScrollPane();
        scrollInstrument.setBorder(null);
        scrollInstrument.setViewportView(this.instrumentInfo);
        JScrollPane scrollPreset = new JScrollPane();
        scrollPreset.setBorder(null);
        scrollPreset.setViewportView(this.presetInfo);
        tabs.add("Instruments", scrollInstrument);
        tabs.add("Presets", scrollPreset);
        split.add((Component)fTree, "left");
        split.add((Component)tabs, "right");
        split.setDividerLocation(200);
    }

    protected void getSoundFontInfo(File f) {
        SoundFontInfo info = SoundFontUtility.getSoundFontInfo(f.getAbsolutePath());
        this.instrumentInfo.setModel(info.instrumentTableModel);
        this.presetInfo.setModel(info.presetTableModel);
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        GUI.showComponentAsStandalone((Component)new SoundFontViewer(), (String)"Sound Font Viewer", (boolean)true);
    }

    private class SFFileTreePopup
    extends JPopupMenu
    implements FileTreePopup {
        private File file;

        public SFFileTreePopup() {
            JMenuItem menuItem = new JMenuItem("Copy Path");
            menuItem.addActionListener(arg0 -> {
                if (this.file != null && this.file.exists() && this.file.isFile()) {
                    Clipboard clipboard = this.getToolkit().getSystemClipboard();
                    clipboard.setContents(new StringSelection(this.file.getAbsolutePath()), null);
                }
            });
            this.add(menuItem);
        }

        @Override
        public void show(File f, Component c, int x, int y) {
            this.file = f;
            this.show(c, x, y);
        }
    }
}

