/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core;

import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class BackupFileSaver
implements Runnable {
    private final long waitTime = 60000L;
    boolean shouldRun = true;
    private BlueProjectManager projectManager = BlueProjectManager.getInstance();

    @Override
    public void run() {
        while (this.shouldRun) {
            this.saveFileBackups();
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                this.shouldRun = false;
            }
        }
    }

    private void saveFileBackups() {
        for (int i = 0; i < this.projectManager.getNumProjects(); ++i) {
            BlueProject bdf = this.projectManager.getProject(i);
            if (bdf.getDataFile() == null || bdf.isOpenedFromTempFile()) continue;
            if (bdf.getTempFile() == null) {
                bdf.setTempFile(new File(bdf.getDataFile().getAbsolutePath() + "~"));
            }
            try (PrintWriter out2 = new PrintWriter(new FileWriter(bdf.getTempFile()));){
                out2.print(bdf.getData().saveAsXML().toString());
                out2.flush();
                continue;
            }
            catch (IOException out2) {
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void quitFileSaver() {
        this.shouldRun = false;
    }
}

