/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.editor.actions;

import blue.tools.codeRepository.CodeRepositoryManager;
import blue.tools.codeRepository.ElementHolder;
import blue.ui.editor.actions.NameValueTextAction;
import electric.xml.ParseException;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.netbeans.editor.BaseAction;
import org.openide.util.Exceptions;
import org.openide.util.actions.Presenter;

public class CodeRepositoryMenu
extends BaseAction
implements Presenter.Popup {
    private static JMenu menu;

    public static void reinitialize() {
        menu = new JMenu("Custom");
        try {
            TreeNode root = CodeRepositoryManager.getCodeRepositoryTreeNode(true);
            CodeRepositoryMenu.handleOpcodeDocCategory(menu, root);
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected static void handleOpcodeDocCategory(JMenu menu, TreeNode category) {
        ArrayList<ElementHolder> snippets = new ArrayList<ElementHolder>();
        for (int i = 0; i < category.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)category.getChildAt(i);
            ElementHolder info = (ElementHolder)node.getUserObject();
            if (info.isGroup) {
                JMenu subMenu = new JMenu(info.title);
                menu.add(subMenu);
                CodeRepositoryMenu.handleOpcodeDocCategory(subMenu, node);
                continue;
            }
            snippets.add(info);
        }
        JMenu currentMenu = menu;
        int counter = 0;
        for (ElementHolder info : snippets) {
            currentMenu.add((Action)new NameValueTextAction(info.title, info.text));
            if (counter != 15) continue;
            JMenu more = new JMenu("More");
            currentMenu.add(more);
            currentMenu = more;
            counter = 0;
        }
    }

    public JMenuItem getPopupPresenter() {
        return menu;
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
    }

    static {
        CodeRepositoryMenu.reinitialize();
    }
}

