/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.globals;

import blue.GlobalOrcSco;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import blue.ui.utilities.SimpleDocumentListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoManager;
import org.openide.awt.UndoRedo;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="GlobalOrchestraTopComponent", persistenceType=0)
public final class GlobalOrchestraTopComponent
extends TopComponent {
    private static GlobalOrchestraTopComponent instance;
    private GlobalOrcSco globalOrcSco = null;
    UndoManager undo = new UndoRedo.Manager();
    MimeTypeEditorComponent editor;

    private GlobalOrchestraTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(GlobalOrchestraTopComponent.class, (String)"CTL_GlobalOrchestraTopComponent"));
        this.setToolTipText(NbBundle.getMessage(GlobalOrchestraTopComponent.class, (String)"HINT_GlobalOrchestraTopComponent"));
        this.editor = new MimeTypeEditorComponent("text/x-csound-orc");
        this.add((Component)this.editor, "Center");
        this.editor.getDocument().addUndoableEditListener(this.undo);
        BlueProjectManager.getInstance().addPropertyChangeListener(evt -> {
            if ("currentProject".equals(evt.getPropertyName())) {
                this.globalOrcSco = null;
                this.reinitialize();
            }
        });
        this.reinitialize();
        this.editor.setUndoManager(this.undo);
        this.editor.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (GlobalOrchestraTopComponent.this.globalOrcSco != null) {
                    GlobalOrchestraTopComponent.this.globalOrcSco.setGlobalOrc(GlobalOrchestraTopComponent.this.editor.getText());
                }
            }
        });
    }

    private void reinitialize() {
        BlueProject project = BlueProjectManager.getInstance().getCurrentProject();
        if (project == null) {
            this.editor.setText("");
            this.editor.getJEditorPane().setEditable(false);
        } else {
            GlobalOrcSco localGlobals = project.getData().getGlobalOrcSco();
            this.editor.setText(localGlobals.getGlobalOrc());
            this.editor.getJEditorPane().setEditable(true);
            this.globalOrcSco = localGlobals;
        }
        this.editor.getJEditorPane().setCaretPosition(0);
        this.undo.discardAllEdits();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

