/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.mixer.Channel;
import blue.mixer.ChannelList;
import blue.mixer.Mixer;
import blue.ui.core.mixer.ChannelListLayout;
import blue.util.ObservableListEvent;
import blue.util.ObservableListListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.openide.windows.WindowManager;

public class MixerChannelsColumnHeader
extends JPanel
implements ObservableListListener {
    private static final int CHANNEL_STRIP_WIDTH = 90;
    Mixer mixer = null;

    public MixerChannelsColumnHeader(final JComponent channelGroupsPanel) {
        this.setPreferredSize(new Dimension(channelGroupsPanel.getWidth(), 22));
        this.setSize(new Dimension(400, 22));
        this.setLayout(new ChannelListLayout());
        this.setBackground(Color.BLACK);
        channelGroupsPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension d = new Dimension(channelGroupsPanel.getWidth(), 22);
                MixerChannelsColumnHeader.this.setPreferredSize(d);
                MixerChannelsColumnHeader.this.setSize(d);
                MixerChannelsColumnHeader.this.invalidate();
            }
        });
    }

    public void listChanged(ObservableListEvent listEvent) {
        this.rebuildUI();
    }

    protected void rebuildUI() {
        this.removeAll();
        for (ChannelList list : this.mixer.getChannelListGroups()) {
            this.add(new NamePanel(list, 0));
        }
        this.add(new NamePanel(this.mixer.getChannels(), 0));
        this.add(new NamePanel(this.mixer.getSubChannels(), 90));
        this.repaint();
    }

    public void setMixer(Mixer mixer) {
        if (this.mixer != null) {
            this.mixer.getChannelListGroups().removeListener((ObservableListListener)this);
        }
        this.mixer = mixer;
        this.mixer.getChannelListGroups().addListener((ObservableListListener)this);
        this.rebuildUI();
    }

    static final class NamePanel
    extends JLabel
    implements PropertyChangeListener,
    ObservableListListener<Channel> {
        private final ChannelList list;
        private final int widthAdjust;

        public NamePanel(final ChannelList list, int widthAdjust) {
            this.list = list;
            this.widthAdjust = widthAdjust;
            this.setBackground(this.getBackground().darker().darker());
            this.setOpaque(true);
            this.setBorder(new NamePanelBorder());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() >= 2 && list.isListNameEditSupported() && list.getAssociation() != null) {
                        String originalName = list.getListName();
                        String retVal = JOptionPane.showInputDialog(WindowManager.getDefault().getMainWindow(), "Please Enter Channel List Name", originalName);
                        if (retVal != null && retVal.trim().length() > 0 && !retVal.equals(originalName)) {
                            retVal = retVal.trim();
                            list.setListName(retVal);
                        }
                    }
                }
            });
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.list.size() * 90 + this.widthAdjust, 22);
        }

        @Override
        public void removeNotify() {
            this.list.removePropertyChangeListener((PropertyChangeListener)this);
            this.list.removeListener((ObservableListListener)this);
            super.removeNotify();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.setText(this.list.getListName());
            this.setToolTipText(this.list.getListName());
            this.setSize(this.getPreferredSize());
            this.list.addPropertyChangeListener((PropertyChangeListener)this);
            this.list.addListener((ObservableListListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("listName".equals(evt.getPropertyName())) {
                this.setText(this.list.getListName());
                this.setToolTipText(this.list.getListName());
                this.invalidate();
                this.repaint();
            }
        }

        public void listChanged(ObservableListEvent<Channel> listEvent) {
            this.setSize(this.getPreferredSize());
        }
    }

    static final class NamePanelBorder
    implements Border {
        private static final Insets insets = new Insets(0, 5, 0, 0);

        NamePanelBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(new Color(255, 255, 255, 32));
            g.drawLine(0, 0, 0, height);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

