/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.project;

import blue.BlueData;
import blue.BlueSystem;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.settings.DiskRenderSettings;
import blue.ui.core.project.RenderToDiskUtility;
import blue.ui.core.render.ProcessConsole;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import org.openide.windows.WindowManager;

public final class RenderToDiskAndOpenAction
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        BlueData data;
        BlueProject project = BlueProjectManager.getInstance().getCurrentProject();
        if (project != null && (data = project.getData()) != null) {
            RenderToDiskUtility.getInstance().renderToDisk(data, f -> {
                DiskRenderSettings settings = DiskRenderSettings.getInstance();
                String command = settings.externalOpenCommand;
                try {
                    if (System.getProperty("os.name").contains("Windows")) {
                        String p = f.getAbsolutePath().replace("\\", "\\\\");
                        command = command.replaceAll("\\$outfile", p);
                        Runtime.getRuntime().exec(command);
                    } else {
                        command = command.replaceAll("\\$outfile", f.getAbsolutePath());
                        String[] cmdArray = ProcessConsole.splitCommandString(command);
                        Runtime.getRuntime().exec(cmdArray);
                    }
                    System.out.println(command);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Could not run command: " + command, "Error", 0);
                    System.err.println("[" + BlueSystem.getString((String)"message.error") + "] - " + ex.getLocalizedMessage());
                    ex.printStackTrace();
                }
            });
        }
    }
}

