/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.layers.soundObject.actions;

import blue.BlueData;
import blue.SoundLayer;
import blue.SoundObjectLibrary;
import blue.projects.BlueProjectManager;
import blue.score.ScoreObject;
import blue.score.TimeState;
import blue.score.layers.Layer;
import blue.score.layers.ScoreObjectLayer;
import blue.soundObject.Instance;
import blue.soundObject.PolyObject;
import blue.soundObject.SoundObject;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScorePath;
import blue.ui.core.score.undo.AddScoreObjectEdit;
import blue.undo.BlueUndoManager;
import blue.utility.ScoreUtilities;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class PasteSoundObjectAction
extends AbstractAction
implements ContextAwareAction {
    private Collection<? extends ScoreObject> scoreObjects;
    private Point p;
    private TimeState timeState;
    private final ScorePath scorePath;

    public PasteSoundObjectAction() {
        this(Utilities.actionsGlobalContext());
    }

    private PasteSoundObjectAction(Lookup lookup) {
        super(NbBundle.getMessage(PasteSoundObjectAction.class, (String)"CTL_PasteSoundObjectAction"));
        this.scoreObjects = lookup.lookupAll(ScoreObject.class);
        this.p = (Point)lookup.lookup(Point.class);
        this.timeState = (TimeState)lookup.lookup(TimeState.class);
        this.scorePath = (ScorePath)lookup.lookup(ScorePath.class);
    }

    @Override
    public boolean isEnabled() {
        ScoreController.ScoreObjectBuffer buffer = ScoreController.getInstance().getScoreObjectBuffer();
        return buffer.scoreObjects.size() > 0 && this.scorePath.getGlobalLayerForY(this.p.y) != null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        double start = (double)this.p.x / (double)this.timeState.getPixelSecond();
        if (this.timeState.isSnapEnabled()) {
            start = ScoreUtilities.getSnapValueStart((double)start, (double)this.timeState.getSnapValue());
        }
        ScoreController.ScoreObjectBuffer buffer = ScoreController.getInstance().getScoreObjectBuffer();
        List<Layer> allLayers = this.scorePath.getAllLayers();
        int selectedLayerIndex = this.scorePath.getGlobalLayerIndexForY(this.p.y);
        int minLayer = Integer.MAX_VALUE;
        int maxLayer = Integer.MIN_VALUE;
        double bufferStart = Double.POSITIVE_INFINITY;
        for (int i = 0; i < buffer.scoreObjects.size(); ++i) {
            ScoreObject scoreObj = buffer.scoreObjects.get(i);
            int layer = buffer.layerIndexes.get(i);
            if (scoreObj.getStartTime() < bufferStart) {
                bufferStart = scoreObj.getStartTime();
            }
            if (layer < minLayer) {
                minLayer = layer;
            }
            if (layer <= maxLayer) continue;
            maxLayer = layer;
        }
        int layerTranslation = selectedLayerIndex - minLayer;
        double startTranslation = start - bufferStart;
        if (maxLayer + layerTranslation >= allLayers.size()) {
            JOptionPane.showMessageDialog(null, "Not Enough Layers to Paste");
            return;
        }
        for (int i = 0; i < buffer.scoreObjects.size(); ++i) {
            ScoreObject scoreObj = buffer.scoreObjects.get(i);
            int index = buffer.layerIndexes.get(i);
            Layer layer = allLayers.get(index + layerTranslation);
            if (layer.accepts(scoreObj)) continue;
            JOptionPane.showMessageDialog(null, "Unable to paste due to target layers not accepting types of objects within the copy buffer (i.e. trying to paste a SoundObject into an AudioLayer");
            return;
        }
        BlueData data = BlueProjectManager.getInstance().getCurrentBlueData();
        SoundObjectLibrary sObjLib = data.getSoundObjectLibrary();
        AddScoreObjectEdit undoEdit = null;
        ArrayList<Instance> instanceSoundObjects = new ArrayList<Instance>();
        for (int i = 0; i < buffer.scoreObjects.size(); ++i) {
            ScoreObject sObj = (ScoreObject)buffer.scoreObjects.get(i).deepCopy();
            int newLayerIndex = buffer.layerIndexes.get(i) + layerTranslation;
            if (sObj instanceof Instance) {
                instanceSoundObjects.add((Instance)sObj);
            } else if (sObj instanceof PolyObject) {
                PolyObject pObj = (PolyObject)sObj;
                this.getInstancesFromPolyObject(instanceSoundObjects, pObj);
            }
            sObj.setStartTime(sObj.getStartTime() + startTranslation);
            ScoreObjectLayer layer = (ScoreObjectLayer)allLayers.get(newLayerIndex);
            layer.add((Object)sObj);
            AddScoreObjectEdit tempEdit = new AddScoreObjectEdit(layer, sObj);
            if (undoEdit == null) {
                undoEdit = tempEdit;
                continue;
            }
            undoEdit.addSubEdit(tempEdit);
        }
        this.checkAndAddInstanceSoundObjects(sObjLib, instanceSoundObjects);
        BlueUndoManager.setUndoManager((String)"score");
        BlueUndoManager.addEdit(undoEdit);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new PasteSoundObjectAction(actionContext);
    }

    private void getInstancesFromPolyObject(List<Instance> instanceSoundObjects, PolyObject pObj) {
        for (SoundLayer layer : pObj) {
            for (SoundObject sObj : layer) {
                if (sObj instanceof Instance) {
                    Instance instance = (Instance)sObj;
                    instanceSoundObjects.add(instance);
                    continue;
                }
                if (!(sObj instanceof PolyObject)) continue;
                this.getInstancesFromPolyObject(instanceSoundObjects, (PolyObject)sObj);
            }
        }
    }

    private void checkAndAddInstanceSoundObjects(SoundObjectLibrary sObjLib, List<Instance> instanceSoundObjects) {
        HashMap<SoundObject, SoundObject> originalToCopyMap = new HashMap<SoundObject, SoundObject>();
        for (Instance instance : instanceSoundObjects) {
            SoundObject copy;
            SoundObject instanceSObj = instance.getSoundObject();
            if (sObjLib.contains((Object)instanceSObj)) continue;
            if (originalToCopyMap.containsKey(instanceSObj)) {
                copy = (SoundObject)originalToCopyMap.get(instanceSObj);
            } else {
                copy = instance.getSoundObject().deepCopy();
                sObjLib.addSoundObject(copy);
                originalToCopyMap.put(instanceSObj, copy);
            }
            instance.setSoundObject(copy);
        }
    }
}

