;
; "Triune [disquiet0062-lifeofsine]"
; by Dave Seidel
;
; This is an entry for the Disquiet Junto project of March 7-10 2013.
; 
; The instructions were:
; Step 1: Devise which three sine waves you will employ. They should be different from each other in some evident way.
; Step 2: The track should open with just one of the sine waves.
; Step 3: Add the second sine wave at 5 seconds.
; Step 4: Add the third sine wave at 10 seconds.
; Step 4: Only at 15 seconds should you begin to in any way manipulate any of the source waves.
; 
; I wrote a Csound program that generates three sine waves.
; - The first tone is a 240Hz tone that sounds for the entire piece.
; - The second tone is higher, starting at a ratio of 31/16 relative to the first tone (sharper than a major seventh, derived from the 31st harmonic).
; - The third tone is lower, at a ratio of 16/31 relative to the first tone (the reciprocal of the second tone).
; - After 15 seconds. the second tone starts gliding downwards in pitch until it reaches the ratio of 65/64 (flatter than a minor second, corresponding to the 65th harmonic).
; - Also at 15 seconds, the third tone start gliding upward in pitch until it reaches the ratio of 64/65 (again, the reciprocal of the second tone).
; 
; The output of this project, converted to MP3, canbe streamed and/or downloaded at https://soundcloud.com/mysterybear/triune. 
; 
; More on this 60th Disquiet Junto project at:
; 
; disquiet.com/2013/03/07/disquiet0062-lifeofsine
; 
; More details on the Disquiet Junto at:
; 
; http://soundcloud.com/groups/disquiet-junto/
; 
;
; Generated by blue 2.4.0 (http://blue.kunstmusik.com)
; and then hand-edited for readability.
;

<CsoundSynthesizer>

<CsInstruments>

sr=96000
ksmps=1
nchnls=2
0dbfs=1

giTblSz init  1048577

; sine wave
giFn1 ftgen 1, 0, giTblSz, 10, 1

; initial ratio of oscillator 2 (31/16)
gkf2  init  1.9375

; initial ratio of oscillator 3 (16/32
gkf3  init  0.516129


	opcode pan_equal_power,aa,ak
ain, kpan	xin
kangl		= 	1.57079633 * (kpan + 0.5)
		xout	ain*sin(kangl), ain*cos(kangl)
	endop


	instr 1	;oscillator 1
idur  =	p3        ; duration
iamp  =	ampdb(p4) ; amplitude
ifn   =	p5        ; function table number
ifreq =	p6        ; frequency
ipan  =	p7				; pan (-0.5 to 0.5)
irise =	p8        ; rise time
ifall =	p9        ; fall time

kenv  linen   iamp, irise, idur, ifall
aout  poscil3 kenv, ifreq, ifn

aLeft, aRight	pan_equal_power	aout, ipan
outc	aLeft, aRight
	endin

	instr 2	;oscillator 2
idur  =	p3        ; duration
iamp  =	ampdb(p4) ; amplitude
ifn   =	p5        ; function table number
ifreq =	p6        ; frequency
ipan  =	p7				; pan (-0.5 to 0.5)
irise =	p8        ; rise time
ifall =	p9        ; fall time

kenv  linen   iamp, irise, idur, ifall
aout  poscil3 kenv, ifreq*gkf2, ifn

aLeft, aRight	pan_equal_power	aout, ipan
outc	aLeft, aRight
	endin

	instr 3	;oscillator 3
idur  =	p3        ; duration
iamp  =	ampdb(p4) ; amplitude
ifn   =	p5        ; function table number
ifreq =	p6        ; frequency
ipan  =	p7				; pan (-0.5 to 0.5)
irise =	p8        ; rise time
ifall =	p9        ; fall time

kenv  linen   iamp, irise, idur, ifall
aout  poscil3 kenv, ifreq*gkf3, ifn

aLeft, aRight	pan_equal_power	aout, ipan
outc	aLeft, aRight
	endin

	instr 4	;untitled
kphase line p4, p3, p5
gkf2	tablei kphase, p6, 1
	endin

	instr 5	;untitled
kphase line p4, p3, p5
gkf3	tablei kphase, p6, 1
	endin

</CsInstruments>

<CsScore>

f2 0 16384 -7  1.9375 15564.7998046875 1.015625 819.2001953125 1.015625
f3 0 16384 -7  0.5161290169 15564.7998046875 0.9846153855 819.2001953125 0.9838319421

i1	0.0	240	-6.5	1	240	0	0.1	4
i2	5.0	235	-6.5	1	240	-0.4	0.1	4
i3	10.0	230	-6.5	1	240	0.4	0.1	4
i4	15.0	225	0.0	1	2
i5	15.0	225	0.0	1	3
e

</CsScore>

</CsoundSynthesizer>
