/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class BridgeMethodResolver {
    private BridgeMethodResolver() {
    }

    /*
     * WARNING - void declaration
     */
    public static Method findBridgedMethod(Method method) {
        void var3_6;
        assert (method != null) : "Method must not be null";
        if (!method.isBridge()) {
            return method;
        }
        Method[] methodArray = BridgeMethodResolver.getAllDeclaredMethods(method.getDeclaringClass());
        ArrayList<Method> arrayList = new ArrayList<Method>(methodArray.length);
        for (Method method2 : methodArray) {
            if (!BridgeMethodResolver.isBridgedCandidateFor(method2, method)) continue;
            arrayList.add(method2);
        }
        if (arrayList.size() == 1) {
            Method method3 = (Method)arrayList.get(0);
        } else {
            Method method4 = BridgeMethodResolver.searchCandidates(arrayList, method);
        }
        if (var3_6 == null) {
            throw new IllegalStateException("Unable to locate bridged method for bridge method '" + method + "'");
        }
        return var3_6;
    }

    private static Method searchCandidates(List<Method> list, Method method) {
        Map<TypeVariable<?>, Type> map = BridgeMethodResolver.createTypeVariableMap(method.getDeclaringClass());
        for (int i = 0; i < list.size(); ++i) {
            Method method2 = list.get(i);
            if (!BridgeMethodResolver.isBridgeMethodFor(method, method2, map)) continue;
            return method2;
        }
        return null;
    }

    private static boolean isBridgedCandidateFor(Method method, Method method2) {
        return !method.isBridge() && !method.equals(method2) && method.getName().equals(method2.getName()) && method.getParameterTypes().length == method2.getParameterTypes().length;
    }

    private static boolean isBridgeMethodFor(Method method, Method method2, Map<TypeVariable<?>, Type> map) {
        if (BridgeMethodResolver.isResolvedTypeMatch(method2, method, map)) {
            return true;
        }
        Method method3 = BridgeMethodResolver.findGenericDeclaration(method);
        return method3 != null ? BridgeMethodResolver.isResolvedTypeMatch(method3, method2, map) : false;
    }

    private static Method findGenericDeclaration(Method method) {
        Class<?>[] classArray;
        Class<?> clazz = method.getDeclaringClass().getSuperclass();
        while (!Object.class.equals(clazz)) {
            classArray = BridgeMethodResolver.searchForMatch(clazz, method);
            if (classArray != null && !classArray.isBridge()) {
                return classArray;
            }
            clazz = clazz.getSuperclass();
        }
        for (Class<?> clazz2 : classArray = BridgeMethodResolver.getAllInterfacesForClass(method.getDeclaringClass())) {
            Method method2 = BridgeMethodResolver.searchForMatch(clazz2, method);
            if (method2 == null || method2.isBridge()) continue;
            return method2;
        }
        return null;
    }

    private static boolean isResolvedTypeMatch(Method method, Method method2, Map<TypeVariable<?>, Type> map) {
        Class<?>[] classArray;
        Type[] typeArray = method.getGenericParameterTypes();
        if (typeArray.length != (classArray = method2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < typeArray.length; ++i) {
            Type type;
            Type type2 = typeArray[i];
            Class<?> clazz = classArray[i];
            if (clazz.isArray() && (type = BridgeMethodResolver.getRawType(type2, map)) instanceof GenericArrayType) {
                if (clazz.getComponentType().equals(BridgeMethodResolver.getRawType(((GenericArrayType)type).getGenericComponentType(), map))) break;
                return false;
            }
            if (clazz.equals(BridgeMethodResolver.getRawType(type2, map))) continue;
            return false;
        }
        return true;
    }

    private static Type getRawType(Type type, Map<TypeVariable<?>, Type> map) {
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            Type type2 = map.get(typeVariable);
            return type2 != null ? type2 : Object.class;
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getRawType();
        }
        return type;
    }

    private static Method searchForMatch(Class<?> clazz, Method method) {
        return BridgeMethodResolver.findMethod(clazz, method.getName(), method.getParameterTypes());
    }

    private static Map<TypeVariable<?>, Type> createTypeVariableMap(Class<?> clazz) {
        ParameterizedType parameterizedType;
        HashMap hashMap = new HashMap();
        BridgeMethodResolver.extractTypeVariablesFromGenericInterfaces(clazz.getGenericInterfaces(), hashMap);
        Type type = clazz.getGenericSuperclass();
        Class<?> clazz2 = clazz.getSuperclass();
        while (!Object.class.equals(clazz2)) {
            if (type instanceof ParameterizedType) {
                parameterizedType = (ParameterizedType)type;
                BridgeMethodResolver.populateTypeMapFromParameterizedType(parameterizedType, hashMap);
            }
            BridgeMethodResolver.extractTypeVariablesFromGenericInterfaces(clazz2.getGenericInterfaces(), hashMap);
            type = clazz2.getGenericSuperclass();
            clazz2 = clazz2.getSuperclass();
        }
        clazz2 = clazz;
        while (clazz2.isMemberClass()) {
            type = clazz2.getGenericSuperclass();
            if (type instanceof ParameterizedType) {
                parameterizedType = (ParameterizedType)type;
                BridgeMethodResolver.populateTypeMapFromParameterizedType(parameterizedType, hashMap);
            }
            clazz2 = clazz2.getEnclosingClass();
        }
        return hashMap;
    }

    private static void extractTypeVariablesFromGenericInterfaces(Type[] typeArray, Map<TypeVariable<?>, Type> map) {
        for (Type type : typeArray) {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                BridgeMethodResolver.populateTypeMapFromParameterizedType(parameterizedType, map);
                if (!(parameterizedType.getRawType() instanceof Class)) continue;
                BridgeMethodResolver.extractTypeVariablesFromGenericInterfaces(((Class)parameterizedType.getRawType()).getGenericInterfaces(), map);
                continue;
            }
            if (!(type instanceof Class)) continue;
            BridgeMethodResolver.extractTypeVariablesFromGenericInterfaces(((Class)type).getGenericInterfaces(), map);
        }
    }

    private static void populateTypeMapFromParameterizedType(ParameterizedType parameterizedType, Map<TypeVariable<?>, Type> map) {
        if (parameterizedType.getRawType() instanceof Class) {
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeVariableArray = ((Class)parameterizedType.getRawType()).getTypeParameters();
            for (int i = 0; i < typeArray.length; ++i) {
                Type type = typeArray[i];
                TypeVariable typeVariable = typeVariableArray[i];
                if (type instanceof Class) {
                    map.put(typeVariable, type);
                    continue;
                }
                if (type instanceof GenericArrayType) {
                    map.put(typeVariable, type);
                    continue;
                }
                if (type instanceof ParameterizedType) {
                    map.put(typeVariable, ((ParameterizedType)type).getRawType());
                    continue;
                }
                if (!(type instanceof TypeVariable)) continue;
                TypeVariable typeVariable2 = (TypeVariable)type;
                Class<?> clazz = map.get(typeVariable2);
                if (clazz == null) {
                    clazz = BridgeMethodResolver.extractClassForTypeVariable(typeVariable2);
                }
                if (clazz == null) continue;
                map.put(typeVariable, clazz);
            }
        }
    }

    private static Class<?> extractClassForTypeVariable(TypeVariable<?> typeVariable) {
        Type[] typeArray = typeVariable.getBounds();
        Class<?> clazz = null;
        if (typeArray.length > 0) {
            Type type = typeArray[0];
            if (type instanceof ParameterizedType) {
                clazz = ((ParameterizedType)type).getRawType();
            } else if (type instanceof Class) {
                clazz = type;
            } else if (type instanceof TypeVariable) {
                clazz = BridgeMethodResolver.extractClassForTypeVariable((TypeVariable)type);
            }
        }
        return clazz instanceof Class ? (Class)clazz : null;
    }

    private static Class<?>[] getAllInterfacesForClass(Class<?> clazz) {
        assert (clazz != null) : "Class must not be null";
        if (clazz.isInterface()) {
            return new Class[]{clazz};
        }
        ArrayList arrayList = new ArrayList();
        while (clazz != null) {
            for (int i = 0; i < clazz.getInterfaces().length; ++i) {
                Class<?> clazz2 = clazz.getInterfaces()[i];
                if (arrayList.contains(clazz2)) continue;
                arrayList.add(clazz2);
            }
            clazz = clazz.getSuperclass();
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    private static Method findMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        assert (clazz != null) : "Class must not be null";
        assert (string != null) : "Method name must not be null";
        for (Class<?> clazz2 = clazz; !Object.class.equals(clazz2) && clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Method[] methodArray;
            for (Method method : methodArray = clazz2.isInterface() ? clazz2.getMethods() : clazz2.getDeclaredMethods()) {
                if (!string.equals(method.getName()) || !Arrays.equals(classArray, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    private static Method[] getAllDeclaredMethods(Class<?> clazz) {
        LinkedList<Method> linkedList = new LinkedList<Method>();
        do {
            Method[] methodArray;
            for (Method method : methodArray = clazz.getDeclaredMethods()) {
                linkedList.add(method);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return linkedList.toArray(new Method[linkedList.size()]);
    }
}

