/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.easymock.internal.ArgumentToString;
import org.easymock.internal.MethodSerializationWrapper;
import org.easymock.internal.MocksControl;
import org.easymock.internal.matchers.Captures;

public class Invocation
implements Serializable {
    private static final long serialVersionUID = 1604995470419943411L;
    private static final Object[] NO_ARGS = new Object[0];
    private final Object mock;
    private transient Method method;
    private final Object[] arguments;
    private final Collection<Captures<?>> currentCaptures = new ArrayList(0);

    public Invocation(Object object, Method method, Object[] objectArray) {
        this.mock = object;
        this.method = method;
        this.arguments = Invocation.expandVarArgs(method.isVarArgs(), objectArray);
    }

    private static Object[] expandVarArgs(boolean bl, Object[] objectArray) {
        if (!bl) {
            return objectArray == null ? NO_ARGS : objectArray;
        }
        if (objectArray[objectArray.length - 1] == null) {
            return objectArray;
        }
        Object[] objectArray2 = Invocation.createObjectArray(objectArray[objectArray.length - 1]);
        int n = objectArray.length - 1;
        int n2 = objectArray2.length;
        Object[] objectArray3 = new Object[n + n2];
        System.arraycopy(objectArray, 0, objectArray3, 0, n);
        System.arraycopy(objectArray2, 0, objectArray3, n, n2);
        return objectArray3;
    }

    private static Object[] createObjectArray(Object object) {
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        Object[] objectArray = new Object[Array.getLength(object)];
        for (int i = 0; i < Array.getLength(object); ++i) {
            objectArray[i] = Array.get(object, i);
        }
        return objectArray;
    }

    public Object getMock() {
        return this.mock;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        Invocation invocation = (Invocation)object;
        return this.mock.equals(invocation.mock) && this.method.equals(invocation.method) && this.equalArguments(invocation.arguments);
    }

    public int hashCode() {
        throw new UnsupportedOperationException("hashCode() is not implemented");
    }

    public String toString() {
        return this.getMockAndMethodName() + "(" + ArgumentToString.argumentsToString(this.arguments) + ")";
    }

    private boolean equalArguments(Object[] objectArray) {
        if (this.arguments.length != objectArray.length) {
            return false;
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            Object object = this.arguments[i];
            Object object2 = objectArray[i];
            if (!(this.isPrimitiveParameter(i) ? !object.equals(object2) : object != object2)) continue;
            return false;
        }
        return true;
    }

    private boolean isPrimitiveParameter(int n) {
        Class<?>[] classArray = this.method.getParameterTypes();
        if (this.method.isVarArgs()) {
            n = Math.min(n, classArray.length - 1);
        }
        return classArray[n].isPrimitive();
    }

    public String getMockAndMethodName() {
        String string = this.method.getName();
        if (!this.toStringIsDefined(this.mock)) {
            return string;
        }
        String string2 = this.mock.toString();
        if (Invocation.isJavaIdentifier(string2)) {
            return string2 + "." + string;
        }
        Class clazz = MocksControl.getMockedType(this.mock);
        return clazz.getSimpleName() + "." + string;
    }

    public void addCapture(Captures<Object> captures, Object object) {
        captures.setPotentialValue(object);
        this.currentCaptures.add(captures);
    }

    public void validateCaptures() {
        for (Captures<?> captures : this.currentCaptures) {
            captures.validateCapture();
        }
    }

    public void clearCaptures() {
        for (Captures<?> captures : this.currentCaptures) {
            captures.setPotentialValue(null);
        }
        this.currentCaptures.clear();
    }

    private boolean toStringIsDefined(Object object) {
        try {
            object.getClass().getDeclaredMethod("toString", null).getModifiers();
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public static boolean isJavaIdentifier(String string) {
        if (string.length() == 0 || string.indexOf(32) > -1 || !Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (char c : string.substring(1).toCharArray()) {
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.method = ((MethodSerializationWrapper)objectInputStream.readObject()).getMethod();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException(noSuchMethodException.toString());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(new MethodSerializationWrapper(this.method));
    }
}

