/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.easymock.IArgumentMatcher;
import org.easymock.internal.Invocation;
import org.easymock.internal.MocksControl;
import org.easymock.internal.matchers.And;
import org.easymock.internal.matchers.Not;
import org.easymock.internal.matchers.Or;

public final class LastControl {
    private static final String NO_MATCHERS_FOUND = "no matchers found.";
    private static final ThreadLocal<MocksControl> threadToControl = new ThreadLocal();
    private static final ThreadLocal<List<Invocation>> threadToCurrentInvocation = new ThreadLocal();
    private static final ThreadLocal<List<IArgumentMatcher>> threadToArgumentMatcherStack = new ThreadLocal();

    private LastControl() {
    }

    public static void reportLastControl(MocksControl mocksControl) {
        if (mocksControl != null) {
            threadToControl.set(mocksControl);
        } else {
            threadToControl.remove();
        }
    }

    public static MocksControl lastControl() {
        return threadToControl.get();
    }

    public static void reportMatcher(IArgumentMatcher iArgumentMatcher) {
        List<IArgumentMatcher> list = threadToArgumentMatcherStack.get();
        if (list == null) {
            list = new ArrayList<IArgumentMatcher>(5);
            threadToArgumentMatcherStack.set(list);
        }
        list.add(iArgumentMatcher);
    }

    public static List<IArgumentMatcher> pullMatchers() {
        List<IArgumentMatcher> list = threadToArgumentMatcherStack.get();
        if (list == null) {
            return null;
        }
        threadToArgumentMatcherStack.remove();
        return new ArrayList<IArgumentMatcher>(list);
    }

    public static void reportAnd(int n) {
        List<IArgumentMatcher> list = threadToArgumentMatcherStack.get();
        LastControl.assertState(list != null, NO_MATCHERS_FOUND);
        list.add(new And(LastControl.popLastArgumentMatchers(n)));
    }

    public static void reportNot() {
        List<IArgumentMatcher> list = threadToArgumentMatcherStack.get();
        LastControl.assertState(list != null, NO_MATCHERS_FOUND);
        list.add(new Not(LastControl.popLastArgumentMatchers(1).get(0)));
    }

    private static List<IArgumentMatcher> popLastArgumentMatchers(int n) {
        List<IArgumentMatcher> list = threadToArgumentMatcherStack.get();
        LastControl.assertState(list != null, NO_MATCHERS_FOUND);
        LastControl.assertState(list.size() >= n, "" + n + " matchers expected, " + list.size() + " recorded.");
        LinkedList<IArgumentMatcher> linkedList = new LinkedList<IArgumentMatcher>();
        linkedList.addAll(list.subList(list.size() - n, list.size()));
        for (int i = 0; i < n; ++i) {
            list.remove(list.size() - 1);
        }
        return linkedList;
    }

    private static void assertState(boolean bl, String string) {
        if (!bl) {
            threadToArgumentMatcherStack.remove();
            throw new IllegalStateException(string);
        }
    }

    public static void reportOr(int n) {
        List<IArgumentMatcher> list = threadToArgumentMatcherStack.get();
        LastControl.assertState(list != null, NO_MATCHERS_FOUND);
        list.add(new Or(LastControl.popLastArgumentMatchers(n)));
    }

    public static Invocation getCurrentInvocation() {
        List<Invocation> list = threadToCurrentInvocation.get();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static void pushCurrentInvocation(Invocation invocation) {
        List<Invocation> list = threadToCurrentInvocation.get();
        if (list == null) {
            list = new ArrayList<Invocation>(2);
            threadToCurrentInvocation.set(list);
        }
        list.add(invocation);
    }

    public static void popCurrentInvocation() {
        List<Invocation> list = threadToCurrentInvocation.get();
        list.remove(list.size() - 1);
    }
}

