/*  =========================================================================
    filemq - generated layer of public API

    Copyright (c) the Contributors as noted in the AUTHORS file.       
    This file is part of FileMQ, a C implemenation of the protocol:    
    https://github.com/danriegsecker/filemq2.                          
                                                                       
    This Source Code Form is subject to the terms of the Mozilla Public
    License, v. 2.0. If a copy of the MPL was not distributed with this
    file, You can obtain one at http://mozilla.org/MPL/2.0/.           

################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Please refer to the README for information about making permanent changes.  #
################################################################################
    =========================================================================
*/

#ifndef FILEMQ_LIBRARY_H_INCLUDED
#define FILEMQ_LIBRARY_H_INCLUDED

//  Set up environment for the application

//  External dependencies
#include <czmq.h>

//  FILEMQ version macros for compile-time API detection

#define FILEMQ_VERSION_MAJOR 2
#define FILEMQ_VERSION_MINOR 0
#define FILEMQ_VERSION_PATCH 0

#define FILEMQ_MAKE_VERSION(major, minor, patch) \
    ((major) * 10000 + (minor) * 100 + (patch))
#define FILEMQ_VERSION \
    FILEMQ_MAKE_VERSION(FILEMQ_VERSION_MAJOR, FILEMQ_VERSION_MINOR, FILEMQ_VERSION_PATCH)

#if defined (__WINDOWS__)
#   if defined LIBFILEMQ_STATIC
#       define FILEMQ_EXPORT
#   elif defined LIBFILEMQ_EXPORTS
#       define FILEMQ_EXPORT __declspec(dllexport)
#   else
#       define FILEMQ_EXPORT __declspec(dllimport)
#   endif
#else
#   define FILEMQ_EXPORT
#endif

//  Opaque class structures to allow forward references

//  Draft APIs, excluded by default in stable releases
//#define WITH_DRAFTS
#ifdef WITH_DRAFTS
typedef struct _fmq_msg_t fmq_msg_t;
#define FMQ_MSG_T_DEFINED
typedef struct _fmq_server_t fmq_server_t;
#define FMQ_SERVER_T_DEFINED
typedef struct _fmq_client_t fmq_client_t;
#define FMQ_CLIENT_T_DEFINED
#endif // WITH_DRAFTS

//  Public API classes

//  Draft APIs, excluded by default in stable releases
#ifdef WITH_DRAFTS
#include "fmq_msg.h"
#include "fmq_server.h"
#include "fmq_client.h"
#endif // WITH_DRAFTS

#endif
/*
################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Please refer to the README for information about making permanent changes.  #
################################################################################
*/
