/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.fontbox.ttf.TTFDataStream;

class MemoryTTFDataStream
extends TTFDataStream {
    private byte[] data = null;
    private int currentPosition = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MemoryTTFDataStream(InputStream inputStream) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            this.data = byteArrayOutputStream.toByteArray();
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public long readLong() throws IOException {
        return ((long)this.readSignedInt() << 32) + ((long)this.readSignedInt() & 0xFFFFFFFFL);
    }

    public int readSignedInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    @Override
    public int read() throws IOException {
        if (this.currentPosition >= this.data.length) {
            return -1;
        }
        byte by = this.data[this.currentPosition];
        ++this.currentPosition;
        return (by + 256) % 256;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    @Override
    public short readSignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void seek(long l) throws IOException {
        this.currentPosition = (int)l;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.currentPosition < this.data.length) {
            int n3 = Math.min(n2, this.data.length - this.currentPosition);
            System.arraycopy(this.data, this.currentPosition, byArray, n, n3);
            this.currentPosition += n3;
            return n3;
        }
        return -1;
    }

    @Override
    public long getCurrentPosition() throws IOException {
        return this.currentPosition;
    }

    @Override
    public InputStream getOriginalData() throws IOException {
        return new ByteArrayInputStream(this.data);
    }
}

