/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.util.autodetect;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.util.autodetect.FontDirFinder;
import org.apache.fontbox.util.autodetect.MacFontDirFinder;
import org.apache.fontbox.util.autodetect.UnixFontDirFinder;
import org.apache.fontbox.util.autodetect.WindowsFontDirFinder;

public class FontFileFinder {
    private static final Log LOG = LogFactory.getLog(FontFileFinder.class);
    private FontDirFinder fontDirFinder = null;

    private FontDirFinder determineDirFinder() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            return new WindowsFontDirFinder();
        }
        if (string.startsWith("Mac")) {
            return new MacFontDirFinder();
        }
        return new UnixFontDirFinder();
    }

    public List<URI> find() {
        if (this.fontDirFinder == null) {
            this.fontDirFinder = this.determineDirFinder();
        }
        List<File> list = this.fontDirFinder.find();
        ArrayList<URI> arrayList = new ArrayList<URI>();
        for (File file : list) {
            this.walk(file, arrayList);
        }
        return arrayList;
    }

    public List<URI> find(String string) {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        File file = new File(string);
        if (file.isDirectory()) {
            this.walk(file, arrayList);
        }
        return arrayList;
    }

    private void walk(File file, List<URI> list) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    if (file2.getName().startsWith(".")) continue;
                    this.walk(file2, list);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("checkFontfile check " + file2));
                }
                if (!this.checkFontfile(file2)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("checkFontfile found " + file2));
                }
                list.add(file2.toURI());
            }
        }
    }

    private boolean checkFontfile(File file) {
        String string = file.getName().toLowerCase();
        return (string.endsWith(".ttf") || string.endsWith(".otf") || string.endsWith(".pfb") || string.endsWith(".ttc")) && !string.startsWith("fonts.");
    }
}

