/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.util.autodetect;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.fontbox.util.Charsets;
import org.apache.fontbox.util.autodetect.FontDirFinder;

public class WindowsFontDirFinder
implements FontDirFinder {
    private String getWinDir(String string) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process process = string.startsWith("Windows 9") ? runtime.exec("command.com /c echo %windir%") : runtime.exec("cmd.exe /c echo %windir%");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charsets.ISO_8859_1));
        String string2 = bufferedReader.readLine();
        bufferedReader.close();
        return string2;
    }

    @Override
    public List<File> find() {
        File file;
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = null;
        try {
            string = System.getProperty("env.windir");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        String string2 = System.getProperty("os.name");
        if (string == null) {
            try {
                string = this.getWinDir(string2);
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (string != null) {
            File file2;
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if ((file = new File(string + File.separator + "FONTS")).exists() && file.canRead()) {
                arrayList.add(file);
            }
            if ((file2 = new File(string.substring(0, 2) + File.separator + "PSFONTS")).exists() && file2.canRead()) {
                arrayList.add(file2);
            }
        } else {
            char c;
            String string3 = string2.endsWith("NT") ? "WINNT" : "WINDOWS";
            for (c = 'C'; c <= 'E'; c = (char)(c + '\u0001')) {
                file = new File(c + ":" + File.separator + string3 + File.separator + "FONTS");
                try {
                    if (!file.exists() || !file.canRead()) continue;
                    arrayList.add(file);
                    break;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            for (c = 'C'; c <= 'E'; c = (char)(c + '\u0001')) {
                File file3 = new File(c + ":" + File.separator + "PSFONTS");
                try {
                    if (!file3.exists() || !file3.canRead()) continue;
                    arrayList.add(file3);
                    break;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return arrayList;
    }
}

