/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.Db4o;
import com.db4o.config.Configuration;
import com.db4o.defragment.ContextIDMapping;
import com.db4o.defragment.DefragmentConfig;
import com.db4o.defragment.DefragmentInfo;
import com.db4o.defragment.DefragmentListener;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.StoredClass;
import com.db4o.foundation.BooleanByRef;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NonblockingQueue;
import com.db4o.foundation.Procedure4;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.TernaryBool;
import com.db4o.foundation.Visitor4;
import com.db4o.foundation.io.File4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndexStrategy;
import com.db4o.internal.handlers.StringHandler;
import com.db4o.internal.mapping.DefragmentServices;
import com.db4o.internal.mapping.IdSource;
import com.db4o.internal.mapping.MappingNotFoundException;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.slots.Slot;
import com.db4o.io.NonFlushingIoAdapter;
import com.db4o.typehandlers.TypeHandler4;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DefragmentServicesImpl
implements DefragmentServices {
    public static final DbSelector SOURCEDB = new DbSelector(){

        @Override
        LocalObjectContainer db(DefragmentServicesImpl context) {
            return context._sourceDb;
        }
    };
    public static final DbSelector TARGETDB = new DbSelector(){

        @Override
        LocalObjectContainer db(DefragmentServicesImpl context) {
            return context._targetDb;
        }
    };
    private static final long CLASSCOLLECTION_POINTER_ADDRESS = 10L;
    public final LocalObjectContainer _sourceDb;
    final LocalObjectContainer _targetDb;
    private final ContextIDMapping _mapping;
    private DefragmentListener _listener;
    private Queue4 _unindexed = new NonblockingQueue();
    private final Hashtable4 _hasFieldIndexCache = new Hashtable4();
    private DefragmentConfig _defragConfig;
    private Hashtable4 _classIndices = new Hashtable4(16);

    public DefragmentServicesImpl(DefragmentConfig defragConfig, DefragmentListener listener) {
        this._listener = listener;
        Config4Impl originalConfig = (Config4Impl)defragConfig.db4oConfig();
        Configuration sourceConfig = (Configuration)originalConfig.deepClone(null);
        sourceConfig.weakReferences(false);
        sourceConfig.io(new NonFlushingIoAdapter(sourceConfig.io()));
        sourceConfig.readOnly(defragConfig.readOnly());
        this._sourceDb = (LocalObjectContainer)Db4o.openFile(sourceConfig, defragConfig.tempPath()).ext();
        this._sourceDb.showInternalClasses(true);
        this._targetDb = DefragmentServicesImpl.freshYapFile(defragConfig);
        this._mapping = defragConfig.mapping();
        this._mapping.open();
        this._defragConfig = defragConfig;
    }

    static LocalObjectContainer freshYapFile(String fileName, int blockSize) {
        File4.delete(fileName);
        return (LocalObjectContainer)Db4o.openFile(DefragmentConfig.vanillaDb4oConfig(blockSize), fileName).ext();
    }

    static LocalObjectContainer freshYapFile(DefragmentConfig config) {
        File4.delete(config.origPath());
        return (LocalObjectContainer)Db4o.openFile(config.clonedDb4oConfig(), config.origPath()).ext();
    }

    public int mappedID(int oldID, int defaultID) {
        int mapped = this.internalMappedID(oldID, false);
        return mapped != 0 ? mapped : defaultID;
    }

    @Override
    public int mappedID(int oldID) throws MappingNotFoundException {
        int mapped = this.internalMappedID(oldID, false);
        if (mapped == 0) {
            throw new MappingNotFoundException(oldID);
        }
        return mapped;
    }

    @Override
    public int mappedID(int id, boolean lenient) throws MappingNotFoundException {
        if (id == 0) {
            return 0;
        }
        int mapped = this.internalMappedID(id, lenient);
        if (mapped == 0) {
            this._listener.notifyDefragmentInfo(new DefragmentInfo("No mapping found for ID " + id));
            return 0;
        }
        return mapped;
    }

    private int internalMappedID(int oldID, boolean lenient) throws MappingNotFoundException {
        if (oldID == 0) {
            return 0;
        }
        if (this._sourceDb.handlers().isSystemHandler(oldID)) {
            return oldID;
        }
        return this._mapping.mappedID(oldID, lenient);
    }

    @Override
    public void mapIDs(int oldID, int newID, boolean isClassID) {
        this._mapping.mapIDs(oldID, newID, isClassID);
    }

    public void close() {
        this._sourceDb.close();
        this._targetDb.close();
        this._mapping.close();
    }

    public ByteArrayBuffer bufferByID(DbSelector selector, int id) {
        Slot slot = this.readPointer(selector, id);
        return this.bufferByAddress(selector, slot.address(), slot.length());
    }

    @Override
    public ByteArrayBuffer sourceBufferByAddress(int address, int length) throws IOException {
        return this.bufferByAddress(SOURCEDB, address, length);
    }

    @Override
    public ByteArrayBuffer targetBufferByAddress(int address, int length) throws IOException {
        return this.bufferByAddress(TARGETDB, address, length);
    }

    public ByteArrayBuffer bufferByAddress(DbSelector selector, int address, int length) {
        return selector.db(this).decryptedBufferByAddress(address, length);
    }

    public StatefulBuffer targetStatefulBufferByAddress(int address, int length) throws IllegalArgumentException {
        return this._targetDb.readWriterByAddress(TARGETDB.transaction(this), address, length);
    }

    @Override
    public Slot allocateTargetSlot(int length) {
        return this._targetDb.getSlot(length);
    }

    @Override
    public void targetWriteBytes(DefragmentContextImpl context, int address) {
        context.write(this._targetDb, address);
    }

    @Override
    public void targetWriteBytes(ByteArrayBuffer reader, int address) {
        this._targetDb.writeBytes(reader, address, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredClass[] storedClasses(DbSelector selector) {
        LocalObjectContainer db = selector.db(this);
        db.showInternalClasses(true);
        try {
            StoredClass[] storedClassArray = db.classCollection().storedClasses();
            return storedClassArray;
        }
        finally {
            db.showInternalClasses(false);
        }
    }

    public LatinStringIO stringIO() {
        return this._sourceDb.stringIO();
    }

    public void targetCommit() {
        this._targetDb.commit();
    }

    public TypeHandler4 sourceHandler(int id) {
        return this._sourceDb.typeHandlerForId(id);
    }

    public int sourceClassCollectionID() {
        return this._sourceDb.classCollection().getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void targetClassCollectionID(String file, int id) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            ByteArrayBuffer reader = new ByteArrayBuffer(4);
            raf.seek(10L);
            reader._offset = 0;
            reader.writeInt(id);
            raf.write(reader._buffer);
        }
    }

    public int classIndexID(ClassMetadata yapClass) {
        return this.classIndex(yapClass).id();
    }

    public void traverseAll(ClassMetadata yapClass, Visitor4 command) {
        if (!yapClass.hasClassIndex()) {
            return;
        }
        yapClass.index().traverseAll(SOURCEDB.transaction(this), command);
    }

    public void traverseAllIndexSlots(ClassMetadata yapClass, Visitor4 command) {
        Iterator4 slotIDIter = yapClass.index().allSlotIDs(SOURCEDB.transaction(this));
        while (slotIDIter.moveNext()) {
            command.visit(slotIDIter.current());
        }
    }

    @Override
    public void traverseAllIndexSlots(BTree btree, Visitor4 command) {
        Iterator4 slotIDIter = btree.allNodeIds(SOURCEDB.transaction(this));
        while (slotIDIter.moveNext()) {
            command.visit(slotIDIter.current());
        }
    }

    public int databaseIdentityID(DbSelector selector) {
        LocalObjectContainer db = selector.db(this);
        Db4oDatabase identity = db.identity();
        if (identity == null) {
            return 0;
        }
        return identity.getID(selector.transaction(this));
    }

    private ClassIndexStrategy classIndex(ClassMetadata yapClass) {
        ClassIndexStrategy classIndex = (ClassIndexStrategy)this._classIndices.get(yapClass);
        if (classIndex == null) {
            classIndex = new BTreeClassIndexStrategy(yapClass);
            this._classIndices.put(yapClass, (Object)classIndex);
            classIndex.initialize(this._targetDb);
        }
        return classIndex;
    }

    @Override
    public Transaction systemTrans() {
        return SOURCEDB.transaction(this);
    }

    public void copyIdentity() {
        this._targetDb.setIdentity(this._sourceDb.identity());
    }

    public void targetClassCollectionID(int newClassCollectionID) {
        this._targetDb.systemData().classCollectionID(newClassCollectionID);
    }

    @Override
    public ByteArrayBuffer sourceBufferByID(int sourceID) {
        return this.bufferByID(SOURCEDB, sourceID);
    }

    public BTree sourceUuidIndex() {
        if (this.sourceUuidIndexID() == 0) {
            return null;
        }
        return this._sourceDb.uUIDIndex().getIndex(this.systemTrans());
    }

    public void targetUuidIndexID(int id) {
        this._targetDb.systemData().uuidIndexId(id);
    }

    public int sourceUuidIndexID() {
        return this._sourceDb.systemData().uuidIndexId();
    }

    @Override
    public ClassMetadata classMetadataForId(int id) {
        return this._sourceDb.classMetadataForId(id);
    }

    @Override
    public void registerUnindexed(int id) {
        this._unindexed.add(new Integer(id));
    }

    @Override
    public IdSource unindexedIDs() {
        return new IdSource(this._unindexed);
    }

    public ObjectHeader sourceObjectHeader(ByteArrayBuffer buffer) {
        return new ObjectHeader(this._sourceDb, (ReadWriteBuffer)buffer);
    }

    private Slot readPointer(DbSelector selector, int id) {
        ByteArrayBuffer reader = selector.db(this).rawBufferByAddress(id, 8);
        int address = reader.readInt();
        int length = reader.readInt();
        return new Slot(address, length);
    }

    public boolean hasFieldIndex(ClassMetadata clazz) {
        TernaryBool cachedHasFieldIndex = (TernaryBool)this._hasFieldIndexCache.get(clazz);
        if (cachedHasFieldIndex != null) {
            return cachedHasFieldIndex.definiteYes();
        }
        final BooleanByRef hasFieldIndex = new BooleanByRef(false);
        for (ClassMetadata curClazz = clazz; !hasFieldIndex.value && curClazz != null; curClazz = curClazz.getAncestor()) {
            curClazz.forEachDeclaredField(new Procedure4(){

                @Override
                public void apply(Object arg) {
                    FieldMetadata curField = (FieldMetadata)arg;
                    if (curField.hasIndex() && curField.getHandler() instanceof StringHandler) {
                        hasFieldIndex.value = true;
                    }
                }
            });
        }
        this._hasFieldIndexCache.put(clazz, (Object)TernaryBool.forBoolean(hasFieldIndex.value));
        return hasFieldIndex.value;
    }

    public int blockSize() {
        return this._sourceDb.config().blockSize();
    }

    @Override
    public int sourceAddressByID(int sourceID) {
        return this.readPointer(SOURCEDB, sourceID).address();
    }

    public boolean accept(StoredClass klass) {
        return this._defragConfig.storedClassFilter().accept(klass);
    }

    public static abstract class DbSelector {
        DbSelector() {
        }

        abstract LocalObjectContainer db(DefragmentServicesImpl var1);

        Transaction transaction(DefragmentServicesImpl context) {
            return this.db(context).systemTransaction();
        }
    }
}

