/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Comparison4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.BTreeRangeKeyIterator;
import com.db4o.internal.btree.BTreeRangePointerIterator;
import com.db4o.internal.btree.BTreeRangeVisitor;
import com.db4o.internal.btree.algebra.BTreeRangeSingleIntersect;
import com.db4o.internal.btree.algebra.BTreeRangeSingleUnion;

public class BTreeRangeSingle
implements BTreeRange {
    public static final Comparison4 COMPARISON = new Comparison4(){

        @Override
        public int compare(Object x, Object y) {
            BTreeRangeSingle xRange = (BTreeRangeSingle)x;
            BTreeRangeSingle yRange = (BTreeRangeSingle)y;
            return xRange.first().compareTo(yRange.first());
        }
    };
    private final Transaction _transaction;
    private final BTree _btree;
    private final BTreePointer _first;
    private final BTreePointer _end;

    public BTreeRangeSingle(Transaction transaction, BTree btree, BTreePointer first, BTreePointer end) {
        if (transaction == null || btree == null) {
            throw new ArgumentNullException();
        }
        this._transaction = transaction;
        this._btree = btree;
        this._first = first;
        this._end = end;
    }

    @Override
    public void accept(BTreeRangeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isEmpty() {
        return BTreePointer.equals(this._first, this._end);
    }

    @Override
    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        int size = 0;
        Iterator4 i = this.keys();
        while (i.moveNext()) {
            ++size;
        }
        return size;
    }

    @Override
    public Iterator4 pointers() {
        return new BTreeRangePointerIterator(this);
    }

    @Override
    public Iterator4 keys() {
        return new BTreeRangeKeyIterator(this);
    }

    public final BTreePointer end() {
        return this._end;
    }

    public Transaction transaction() {
        return this._transaction;
    }

    public BTreePointer first() {
        return this._first;
    }

    @Override
    public BTreeRange greater() {
        return this.newBTreeRangeSingle(this._end, null);
    }

    @Override
    public BTreeRange union(BTreeRange other) {
        if (null == other) {
            throw new ArgumentNullException();
        }
        return new BTreeRangeSingleUnion(this).dispatch(other);
    }

    public boolean adjacent(BTreeRangeSingle range) {
        return BTreePointer.equals(this._end, range._first) || BTreePointer.equals(range._end, this._first);
    }

    public boolean overlaps(BTreeRangeSingle range) {
        return this.firstOverlaps(this, range) || this.firstOverlaps(range, this);
    }

    private boolean firstOverlaps(BTreeRangeSingle x, BTreeRangeSingle y) {
        return BTreePointer.lessThan(y._first, x._end) && BTreePointer.lessThan(x._first, y._end);
    }

    @Override
    public BTreeRange extendToFirst() {
        return this.newBTreeRangeSingle(this.firstBTreePointer(), this._end);
    }

    @Override
    public BTreeRange extendToLast() {
        return this.newBTreeRangeSingle(this._first, null);
    }

    @Override
    public BTreeRange smaller() {
        return this.newBTreeRangeSingle(this.firstBTreePointer(), this._first);
    }

    public BTreeRangeSingle newBTreeRangeSingle(BTreePointer first, BTreePointer end) {
        return new BTreeRangeSingle(this.transaction(), this._btree, first, end);
    }

    public BTreeRange newEmptyRange() {
        return this.newBTreeRangeSingle(null, null);
    }

    private BTreePointer firstBTreePointer() {
        return this.btree().firstPointer(this.transaction());
    }

    private BTree btree() {
        return this._btree;
    }

    @Override
    public BTreeRange intersect(BTreeRange range) {
        if (null == range) {
            throw new ArgumentNullException();
        }
        return new BTreeRangeSingleIntersect(this).dispatch(range);
    }

    @Override
    public BTreeRange extendToLastOf(BTreeRange range) {
        BTreeRangeSingle rangeImpl = this.checkRangeArgument(range);
        return this.newBTreeRangeSingle(this._first, rangeImpl._end);
    }

    public String toString() {
        return "BTreeRangeSingle(first=" + this._first + ", end=" + this._end + ")";
    }

    private BTreeRangeSingle checkRangeArgument(BTreeRange range) {
        if (null == range) {
            throw new ArgumentNullException();
        }
        BTreeRangeSingle rangeImpl = (BTreeRangeSingle)range;
        if (this.btree() != rangeImpl.btree()) {
            throw new IllegalArgumentException();
        }
        return rangeImpl;
    }

    @Override
    public BTreePointer lastPointer() {
        if (this._end == null) {
            return this.btree().lastPointer(this.transaction());
        }
        return this._end.previous();
    }
}

