/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.foundation.No4;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeCancelledRemoval;
import com.db4o.internal.btree.BTreePatch;
import com.db4o.internal.btree.BTreeRemove;

public abstract class BTreeUpdate
extends BTreePatch {
    protected BTreeUpdate _next;

    public BTreeUpdate(Transaction transaction, Object obj) {
        super(transaction, obj);
    }

    protected boolean hasNext() {
        return this._next != null;
    }

    @Override
    public BTreePatch forTransaction(Transaction trans) {
        if (this._transaction == trans) {
            return this;
        }
        if (this._next == null) {
            return null;
        }
        return this._next.forTransaction(trans);
    }

    public BTreeUpdate removeFor(Transaction trans) {
        if (this._transaction == trans) {
            return this._next;
        }
        if (this._next == null) {
            return this;
        }
        return this._next.removeFor(trans);
    }

    public void append(BTreeUpdate patch) {
        if (this._transaction == patch._transaction) {
            throw new IllegalArgumentException();
        }
        if (!this.hasNext()) {
            this._next = patch;
        } else {
            this._next.append(patch);
        }
    }

    protected void applyKeyChange(Object obj) {
        this._object = obj;
        if (this.hasNext()) {
            this._next.applyKeyChange(obj);
        }
    }

    protected abstract void committed(BTree var1);

    @Override
    public Object commit(Transaction trans, BTree btree) {
        BTreeUpdate patch = (BTreeUpdate)this.forTransaction(trans);
        if (patch instanceof BTreeCancelledRemoval) {
            Object obj = patch.getCommittedObject();
            this.applyKeyChange(obj);
        } else if (patch instanceof BTreeRemove) {
            this.removedBy(trans, btree);
            patch.committed(btree);
            return No4.INSTANCE;
        }
        return this.internalCommit(trans, btree);
    }

    protected final Object internalCommit(Transaction trans, BTree btree) {
        if (this._transaction == trans) {
            this.committed(btree);
            if (this.hasNext()) {
                return this._next;
            }
            return this.getCommittedObject();
        }
        if (this.hasNext()) {
            this.setNextIfPatch(this._next.internalCommit(trans, btree));
        }
        return this;
    }

    private void setNextIfPatch(Object newNext) {
        this._next = newNext instanceof BTreeUpdate ? (BTreeUpdate)newNext : null;
    }

    protected abstract Object getCommittedObject();

    @Override
    public Object rollback(Transaction trans, BTree btree) {
        if (this._transaction == trans) {
            if (this.hasNext()) {
                return this._next;
            }
            return this.getObject();
        }
        if (this.hasNext()) {
            this.setNextIfPatch(this._next.rollback(trans, btree));
        }
        return this;
    }

    @Override
    public Object key(Transaction trans) {
        BTreePatch patch = this.forTransaction(trans);
        if (patch == null) {
            return this.getObject();
        }
        if (patch.isRemove()) {
            return No4.INSTANCE;
        }
        return patch.getObject();
    }

    public BTreeUpdate replacePatch(BTreePatch patch, BTreeUpdate update) {
        if (patch == this) {
            update._next = this._next;
            return update;
        }
        if (this._next == null) {
            throw new IllegalStateException();
        }
        this._next = this._next.replacePatch(patch, update);
        return this;
    }

    public void removedBy(Transaction trans, BTree btree) {
        if (trans != this._transaction) {
            this.adjustSizeOnRemovalByOtherTransaction(btree);
        }
        if (this.hasNext()) {
            this._next.removedBy(trans, btree);
        }
    }

    protected abstract void adjustSizeOnRemovalByOtherTransaction(BTree var1);
}

