/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.classindex;

import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.classindex.AbstractClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndexStrategy;

public class BTreeClassIndexStrategy
extends AbstractClassIndexStrategy {
    private BTree _btreeIndex;

    public BTreeClassIndexStrategy(ClassMetadata yapClass) {
        super(yapClass);
    }

    public BTree btree() {
        return this._btreeIndex;
    }

    @Override
    public int entryCount(Transaction ta) {
        return this._btreeIndex != null ? this._btreeIndex.size(ta) : 0;
    }

    @Override
    public void initialize(ObjectContainerBase stream) {
        this.createBTreeIndex(stream, 0);
    }

    @Override
    public void purge() {
    }

    @Override
    public void read(ObjectContainerBase stream, int indexID) {
        this.readBTreeIndex(stream, indexID);
    }

    @Override
    public int write(Transaction trans) {
        if (this._btreeIndex == null) {
            return 0;
        }
        this._btreeIndex.write(trans);
        return this._btreeIndex.getID();
    }

    @Override
    public void traverseAll(Transaction ta, Visitor4 command) {
        if (this._btreeIndex != null) {
            this._btreeIndex.traverseKeys(ta, command);
        }
    }

    private void createBTreeIndex(final ObjectContainerBase stream, int btreeID) {
        if (stream.isClient()) {
            return;
        }
        this._btreeIndex = ((LocalObjectContainer)stream).createBTreeClassIndex(btreeID);
        this._btreeIndex.setRemoveListener(new Visitor4(){

            @Override
            public void visit(Object obj) {
                int id = (Integer)obj;
                stream.referenceSystemRegistry().removeId(id);
            }
        });
    }

    private void readBTreeIndex(ObjectContainerBase stream, int indexId) {
        if (!stream.isClient() && this._btreeIndex == null) {
            this.createBTreeIndex(stream, indexId);
        }
    }

    @Override
    protected void internalAdd(Transaction trans, int id) {
        this._btreeIndex.add(trans, new Integer(id));
    }

    @Override
    protected void internalRemove(Transaction ta, int id) {
        this._btreeIndex.remove(ta, new Integer(id));
    }

    @Override
    public void dontDelete(Transaction transaction, int id) {
    }

    @Override
    public void defragReference(ClassMetadata classMetadata, DefragmentContextImpl context, int classIndexID) {
        int newID = -classIndexID;
        context.writeInt(newID);
    }

    @Override
    public int id() {
        return this._btreeIndex.getID();
    }

    @Override
    public Iterator4 allSlotIDs(Transaction trans) {
        return this._btreeIndex.allNodeIds(trans);
    }

    @Override
    public void defragIndex(DefragmentContextImpl context) {
        this._btreeIndex.defragIndex(context);
    }

    public static BTree btree(ClassMetadata clazz) {
        ClassIndexStrategy index = clazz.index();
        if (!(index instanceof BTreeClassIndexStrategy)) {
            throw new IllegalStateException();
        }
        return ((BTreeClassIndexStrategy)index).btree();
    }

    public static Iterator4 iterate(ClassMetadata clazz, Transaction trans) {
        return BTreeClassIndexStrategy.btree(clazz).asRange(trans).keys();
    }
}

