/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.events;

import com.db4o.ObjectContainer;
import com.db4o.events.Event4;
import com.db4o.events.EventRegistry;
import com.db4o.internal.CallbackObjectInfoCollections;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.Transaction;
import com.db4o.internal.callbacks.Callbacks;
import com.db4o.internal.events.Event4Impl;
import com.db4o.internal.events.EventPlatform;
import com.db4o.query.Query;

public class EventRegistryImpl
implements Callbacks,
EventRegistry {
    private final InternalObjectContainer _container;
    protected final Event4Impl _queryStarted = new Event4Impl();
    protected final Event4Impl _queryFinished = new Event4Impl();
    protected final Event4Impl _creating = new Event4Impl();
    protected final Event4Impl _activating = new Event4Impl();
    protected final Event4Impl _updating = new Event4Impl();
    protected final Event4Impl _deleting = new Event4Impl();
    protected final Event4Impl _deactivating = new Event4Impl();
    protected final Event4Impl _created = new Event4Impl();
    protected final Event4Impl _activated = new Event4Impl();
    protected final Event4Impl _updated = new Event4Impl();
    protected final Event4Impl _deleted = new Event4Impl();
    protected final Event4Impl _deactivated = new Event4Impl();
    protected final Event4Impl _committing = new Event4Impl();
    protected final Event4Impl _committed = new CommittedEvent();
    protected final Event4Impl _instantiated = new Event4Impl();
    protected final Event4Impl _classRegistered = new Event4Impl();
    protected final Event4Impl _closing = new Event4Impl();

    public EventRegistryImpl(InternalObjectContainer container) {
        this._container = container;
    }

    @Override
    public void queryOnFinished(Transaction transaction, Query query) {
        EventPlatform.triggerQueryEvent(transaction, this._queryFinished, query);
    }

    @Override
    public void queryOnStarted(Transaction transaction, Query query) {
        EventPlatform.triggerQueryEvent(transaction, this._queryStarted, query);
    }

    @Override
    public boolean objectCanNew(Transaction transaction, Object obj) {
        return EventPlatform.triggerCancellableObjectEventArgs(transaction, this._creating, obj);
    }

    @Override
    public boolean objectCanActivate(Transaction transaction, Object obj) {
        return EventPlatform.triggerCancellableObjectEventArgs(transaction, this._activating, obj);
    }

    @Override
    public boolean objectCanUpdate(Transaction transaction, Object obj) {
        return EventPlatform.triggerCancellableObjectEventArgs(transaction, this._updating, obj);
    }

    @Override
    public boolean objectCanDelete(Transaction transaction, Object obj) {
        return EventPlatform.triggerCancellableObjectEventArgs(transaction, this._deleting, obj);
    }

    @Override
    public boolean objectCanDeactivate(Transaction transaction, Object obj) {
        return EventPlatform.triggerCancellableObjectEventArgs(transaction, this._deactivating, obj);
    }

    @Override
    public void objectOnActivate(Transaction transaction, Object obj) {
        EventPlatform.triggerObjectEvent(transaction, this._activated, obj);
    }

    @Override
    public void objectOnNew(Transaction transaction, Object obj) {
        EventPlatform.triggerObjectEvent(transaction, this._created, obj);
    }

    @Override
    public void objectOnUpdate(Transaction transaction, Object obj) {
        EventPlatform.triggerObjectEvent(transaction, this._updated, obj);
    }

    @Override
    public void objectOnDelete(Transaction transaction, Object obj) {
        EventPlatform.triggerObjectEvent(transaction, this._deleted, obj);
    }

    @Override
    public void classOnRegistered(ClassMetadata clazz) {
        EventPlatform.triggerClassEvent(this._classRegistered, clazz);
    }

    @Override
    public void objectOnDeactivate(Transaction transaction, Object obj) {
        EventPlatform.triggerObjectEvent(transaction, this._deactivated, obj);
    }

    @Override
    public void objectOnInstantiate(Transaction transaction, Object obj) {
        EventPlatform.triggerObjectEvent(transaction, this._instantiated, obj);
    }

    @Override
    public void commitOnStarted(Transaction transaction, CallbackObjectInfoCollections objectInfoCollections) {
        EventPlatform.triggerCommitEvent(transaction, this._committing, objectInfoCollections);
    }

    @Override
    public void commitOnCompleted(Transaction transaction, CallbackObjectInfoCollections objectInfoCollections) {
        EventPlatform.triggerCommitEvent(transaction, this._committed, objectInfoCollections);
    }

    @Override
    public void closeOnStarted(ObjectContainer container) {
        EventPlatform.triggerObjectContainerEvent(container, this._closing);
    }

    @Override
    public Event4 queryFinished() {
        return this._queryFinished;
    }

    @Override
    public Event4 queryStarted() {
        return this._queryStarted;
    }

    @Override
    public Event4 creating() {
        return this._creating;
    }

    @Override
    public Event4 activating() {
        return this._activating;
    }

    @Override
    public Event4 updating() {
        return this._updating;
    }

    @Override
    public Event4 deleting() {
        return this._deleting;
    }

    @Override
    public Event4 deactivating() {
        return this._deactivating;
    }

    @Override
    public Event4 created() {
        return this._created;
    }

    @Override
    public Event4 activated() {
        return this._activated;
    }

    @Override
    public Event4 updated() {
        return this._updated;
    }

    @Override
    public Event4 deleted() {
        return this._deleted;
    }

    @Override
    public Event4 deactivated() {
        return this._deactivated;
    }

    @Override
    public Event4 committing() {
        return this._committing;
    }

    @Override
    public Event4 committed() {
        return this._committed;
    }

    @Override
    public Event4 classRegistered() {
        return this._classRegistered;
    }

    @Override
    public Event4 instantiated() {
        return this._instantiated;
    }

    @Override
    public Event4 closing() {
        return this._closing;
    }

    protected void onCommittedListener() {
        this._container.onCommittedListener();
    }

    @Override
    public boolean caresAboutCommitting() {
        return EventPlatform.hasListeners(this._committing);
    }

    @Override
    public boolean caresAboutCommitted() {
        return EventPlatform.hasListeners(this._committed);
    }

    @Override
    public boolean caresAboutDeleting() {
        return EventPlatform.hasListeners(this._deleting);
    }

    @Override
    public boolean caresAboutDeleted() {
        return EventPlatform.hasListeners(this._deleted);
    }

    protected class CommittedEvent
    extends Event4Impl {
        protected CommittedEvent() {
        }

        @Override
        protected void onListenerAdded() {
            EventRegistryImpl.this.onCommittedListener();
        }
    }
}

