/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fileheader;

import com.db4o.ext.Db4oIOException;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.fileheader.FileHeader;
import com.db4o.internal.fileheader.FileHeaderVariablePart1;
import com.db4o.internal.fileheader.TimerFileLock;

public class FileHeader1
extends FileHeader {
    private static final byte[] SIGNATURE = new byte[]{100, 98, 52, 111};
    private static byte VERSION = 1;
    private static final int HEADER_LOCK_OFFSET = SIGNATURE.length + 1;
    private static final int OPEN_TIME_OFFSET = HEADER_LOCK_OFFSET + 4;
    private static final int ACCESS_TIME_OFFSET = OPEN_TIME_OFFSET + 8;
    private static final int TRANSACTION_POINTER_OFFSET = ACCESS_TIME_OFFSET + 8;
    public static final int HEADER_LENGTH = TRANSACTION_POINTER_OFFSET + 24;
    private TimerFileLock _timerFileLock;
    private Transaction _interruptedTransaction;
    private FileHeaderVariablePart1 _variablePart;

    @Override
    public void close() throws Db4oIOException {
        this._timerFileLock.close();
    }

    @Override
    public void initNew(LocalObjectContainer file) throws Db4oIOException {
        this.commonTasksForNewAndRead(file);
        this._variablePart = new FileHeaderVariablePart1(0, file.systemData());
        this.writeVariablePart(file, 0);
    }

    @Override
    protected FileHeader newOnSignatureMatch(LocalObjectContainer file, ByteArrayBuffer reader) {
        if (this.signatureMatches(reader, SIGNATURE, VERSION)) {
            return new FileHeader1();
        }
        return null;
    }

    private void newTimerFileLock(LocalObjectContainer file) {
        this._timerFileLock = TimerFileLock.forFile(file);
        this._timerFileLock.setAddresses(0, OPEN_TIME_OFFSET, ACCESS_TIME_OFFSET);
    }

    @Override
    public Transaction interruptedTransaction() {
        return this._interruptedTransaction;
    }

    @Override
    public int length() {
        return HEADER_LENGTH;
    }

    @Override
    protected void readFixedPart(LocalObjectContainer file, ByteArrayBuffer reader) {
        this.commonTasksForNewAndRead(file);
        this.checkThreadFileLock(file, reader);
        reader.seek(TRANSACTION_POINTER_OFFSET);
        this._interruptedTransaction = LocalTransaction.readInterruptedTransaction(file, reader);
        file.blockSizeReadFromFile(reader.readInt());
        this.readClassCollectionAndFreeSpace(file, reader);
        this._variablePart = new FileHeaderVariablePart1(reader.readInt(), file.systemData());
    }

    private void checkThreadFileLock(LocalObjectContainer container, ByteArrayBuffer reader) {
        reader.seek(ACCESS_TIME_OFFSET);
        long lastAccessTime = reader.readLong();
        if (FileHeader.lockedByOtherSession(container, lastAccessTime)) {
            this._timerFileLock.checkIfOtherSessionAlive(container, 0, ACCESS_TIME_OFFSET, lastAccessTime);
        }
    }

    private void commonTasksForNewAndRead(LocalObjectContainer file) {
        this.newTimerFileLock(file);
        file._handlers.oldEncryptionOff();
    }

    @Override
    public void readVariablePart(LocalObjectContainer file) {
        this._variablePart.read(file.systemTransaction());
    }

    @Override
    public void writeFixedPart(LocalObjectContainer file, boolean startFileLockingThread, boolean shuttingDown, StatefulBuffer writer, int blockSize, int freespaceID) {
        writer.append(SIGNATURE);
        writer.writeByte(VERSION);
        writer.writeInt((int)this.timeToWrite(this._timerFileLock.openTime(), shuttingDown));
        writer.writeLong(this.timeToWrite(this._timerFileLock.openTime(), shuttingDown));
        writer.writeLong(this.timeToWrite(System.currentTimeMillis(), shuttingDown));
        writer.writeInt(0);
        writer.writeInt(0);
        writer.writeInt(blockSize);
        writer.writeInt(file.systemData().classCollectionID());
        writer.writeInt(freespaceID);
        writer.writeInt(this._variablePart.getID());
        writer.noXByteCheck();
        writer.write();
        file.syncFiles();
        if (startFileLockingThread) {
            this._timerFileLock.start();
        }
    }

    @Override
    public void writeTransactionPointer(Transaction systemTransaction, int transactionAddress) {
        this.writeTransactionPointer(systemTransaction, transactionAddress, 0, TRANSACTION_POINTER_OFFSET);
    }

    @Override
    public void writeVariablePart(LocalObjectContainer file, int part) {
        this._variablePart.setStateDirty();
        this._variablePart.write(file.systemTransaction());
    }
}

