/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.tools;

import com.db4o.ObjectContainer;
import com.db4o.events.Event4;
import com.db4o.events.EventArgs;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistry;
import com.db4o.events.EventRegistryFactory;
import com.db4o.foundation.StopWatch;

public class QueryStats {
    private EventRegistry _registry = null;
    protected int _activationCount;
    protected final StopWatch _watch = new StopWatch();
    private final EventListener4 _queryStarted = new EventListener4(){

        @Override
        public void onEvent(Event4 e, EventArgs args) {
            QueryStats.this._activationCount = 0;
            QueryStats.this._watch.start();
        }
    };
    private final EventListener4 _queryFinished = new EventListener4(){

        @Override
        public void onEvent(Event4 e, EventArgs args) {
            QueryStats.this._watch.stop();
        }
    };
    private final EventListener4 _activated = new EventListener4(){

        @Override
        public void onEvent(Event4 e, EventArgs args) {
            ++QueryStats.this._activationCount;
        }
    };

    public long executionTime() {
        return this._watch.elapsed();
    }

    public int activationCount() {
        return this._activationCount;
    }

    public void connect(ObjectContainer container) {
        if (this._registry != null) {
            throw new IllegalArgumentException("Already connected to an ObjectContainer");
        }
        this._registry = EventRegistryFactory.forObjectContainer(container);
        this._registry.queryStarted().addListener(this._queryStarted);
        this._registry.queryFinished().addListener(this._queryFinished);
        this._registry.activated().addListener(this._activated);
    }

    public void disconnect() {
        if (null != this._registry) {
            this._registry.queryStarted().removeListener(this._queryStarted);
            this._registry.queryFinished().removeListener(this._queryFinished);
            this._registry.activated().removeListener(this._activated);
            this._registry = null;
        }
    }
}

