/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.io;

import com.onionnetworks.io.RAF;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class RAFInputStream
extends InputStream {
    RAF raf;
    long pos;

    public RAFInputStream(RAF raf) {
        this.raf = raf;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.raf == null) {
            throw new EOFException();
        }
        int c = this.raf.seekAndRead(this.pos, b, off, len);
        if (c >= 0) {
            this.pos += (long)c;
        }
        return c;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > 0L) {
            long result = Math.min(this.raf.length(), this.pos + n) - this.pos;
            this.pos += result;
            return result;
        }
        return 0L;
    }

    @Override
    public void close() throws IOException {
        this.raf = null;
    }
}

