/*
 * Decompiled with CFR 0.152.
 */
package org.bitpedia.collider.core;

import org.bitpedia.collider.core.Md4Handler;

public class Ed2Handler {
    private static final int EDSEG_SIZE = 9728000;
    private Md4Handler seg;
    private Md4Handler top;
    private long nextPos;

    public void analyzeInit() {
        this.nextPos = 0L;
        this.seg = new Md4Handler();
        this.seg.analyzeInit();
        this.top = new Md4Handler();
        this.top.analyzeInit();
    }

    public void analyzeUpdate(byte[] byArray, int n) {
        this.analyzeUpdate(byArray, 0, n);
    }

    public void analyzeUpdate(byte[] byArray, int n, int n2) {
        if (0 == n2) {
            return;
        }
        if (0L < this.nextPos && 0L == this.nextPos % 9728000L) {
            byte[] byArray2 = this.seg.analyzeFinal();
            this.top.analyzeUpdate(byArray2, 16);
            this.seg.analyzeInit();
        }
        if (this.nextPos / 9728000L == (this.nextPos + (long)n2) / 9728000L) {
            this.seg.analyzeUpdate(byArray, n, n2);
            this.nextPos += (long)n2;
            return;
        }
        int n3 = 9728000 - (int)(this.nextPos % 9728000L);
        this.seg.analyzeUpdate(byArray, n, n3);
        this.nextPos += (long)n3;
        this.analyzeUpdate(byArray, n + n3, n2 - n3);
    }

    public byte[] analyzeFinal() {
        if (this.nextPos <= 9728000L) {
            return this.seg.analyzeFinal();
        }
        byte[] byArray = this.seg.analyzeFinal();
        this.top.analyzeUpdate(byArray, 16);
        return this.top.analyzeFinal();
    }
}

