/*
 * Decompiled with CFR 0.152.
 */
package org.bitpedia.collider.core;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class Md4Handler {
    private static final int S11 = 3;
    private static final int S12 = 7;
    private static final int S13 = 11;
    private static final int S14 = 19;
    private static final int S21 = 3;
    private static final int S22 = 5;
    private static final int S23 = 9;
    private static final int S24 = 13;
    private static final int S31 = 3;
    private static final int S32 = 9;
    private static final int S33 = 11;
    private static final int S34 = 15;
    private static byte P0 = (byte)-128;
    private static byte[] PADDING = new byte[]{P0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int[] state;
    private int[] count;
    private byte[] buffer;

    private static int F(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    private static int G(int n, int n2, int n3) {
        return n & n2 | n & n3 | n2 & n3;
    }

    private static int H(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private static int rotateLeft(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    private static int FF(int n, int n2, int n3, int n4, int n5, int n6) {
        return Md4Handler.rotateLeft(n += Md4Handler.F(n2, n3, n4) + n5, n6);
    }

    private static int GG(int n, int n2, int n3, int n4, int n5, int n6) {
        return Md4Handler.rotateLeft(n += Md4Handler.G(n2, n3, n4) + n5 + 1518500249, n6);
    }

    private static int HH(int n, int n2, int n3, int n4, int n5, int n6) {
        return Md4Handler.rotateLeft(n += Md4Handler.H(n2, n3, n4) + n5 + 1859775393, n6);
    }

    private static void encode(byte[] byArray, int[] nArray, int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.put(nArray, 0, n / 4);
        byteBuffer.get(byArray, 0, n);
    }

    private static void decode(int[] nArray, byte[] byArray, int n, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.get(nArray, 0, n2 / 4);
    }

    private static void md4Transform(int[] nArray, byte[] byArray, int n) {
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        int[] nArray2 = new int[16];
        Md4Handler.decode(nArray2, byArray, n, 64);
        n2 = Md4Handler.FF(n2, n3, n4, n5, nArray2[0], 3);
        n5 = Md4Handler.FF(n5, n2, n3, n4, nArray2[1], 7);
        n4 = Md4Handler.FF(n4, n5, n2, n3, nArray2[2], 11);
        n3 = Md4Handler.FF(n3, n4, n5, n2, nArray2[3], 19);
        n2 = Md4Handler.FF(n2, n3, n4, n5, nArray2[4], 3);
        n5 = Md4Handler.FF(n5, n2, n3, n4, nArray2[5], 7);
        n4 = Md4Handler.FF(n4, n5, n2, n3, nArray2[6], 11);
        n3 = Md4Handler.FF(n3, n4, n5, n2, nArray2[7], 19);
        n2 = Md4Handler.FF(n2, n3, n4, n5, nArray2[8], 3);
        n5 = Md4Handler.FF(n5, n2, n3, n4, nArray2[9], 7);
        n4 = Md4Handler.FF(n4, n5, n2, n3, nArray2[10], 11);
        n3 = Md4Handler.FF(n3, n4, n5, n2, nArray2[11], 19);
        n2 = Md4Handler.FF(n2, n3, n4, n5, nArray2[12], 3);
        n5 = Md4Handler.FF(n5, n2, n3, n4, nArray2[13], 7);
        n4 = Md4Handler.FF(n4, n5, n2, n3, nArray2[14], 11);
        n3 = Md4Handler.FF(n3, n4, n5, n2, nArray2[15], 19);
        n2 = Md4Handler.GG(n2, n3, n4, n5, nArray2[0], 3);
        n5 = Md4Handler.GG(n5, n2, n3, n4, nArray2[4], 5);
        n4 = Md4Handler.GG(n4, n5, n2, n3, nArray2[8], 9);
        n3 = Md4Handler.GG(n3, n4, n5, n2, nArray2[12], 13);
        n2 = Md4Handler.GG(n2, n3, n4, n5, nArray2[1], 3);
        n5 = Md4Handler.GG(n5, n2, n3, n4, nArray2[5], 5);
        n4 = Md4Handler.GG(n4, n5, n2, n3, nArray2[9], 9);
        n3 = Md4Handler.GG(n3, n4, n5, n2, nArray2[13], 13);
        n2 = Md4Handler.GG(n2, n3, n4, n5, nArray2[2], 3);
        n5 = Md4Handler.GG(n5, n2, n3, n4, nArray2[6], 5);
        n4 = Md4Handler.GG(n4, n5, n2, n3, nArray2[10], 9);
        n3 = Md4Handler.GG(n3, n4, n5, n2, nArray2[14], 13);
        n2 = Md4Handler.GG(n2, n3, n4, n5, nArray2[3], 3);
        n5 = Md4Handler.GG(n5, n2, n3, n4, nArray2[7], 5);
        n4 = Md4Handler.GG(n4, n5, n2, n3, nArray2[11], 9);
        n3 = Md4Handler.GG(n3, n4, n5, n2, nArray2[15], 13);
        n2 = Md4Handler.HH(n2, n3, n4, n5, nArray2[0], 3);
        n5 = Md4Handler.HH(n5, n2, n3, n4, nArray2[8], 9);
        n4 = Md4Handler.HH(n4, n5, n2, n3, nArray2[4], 11);
        n3 = Md4Handler.HH(n3, n4, n5, n2, nArray2[12], 15);
        n2 = Md4Handler.HH(n2, n3, n4, n5, nArray2[2], 3);
        n5 = Md4Handler.HH(n5, n2, n3, n4, nArray2[10], 9);
        n4 = Md4Handler.HH(n4, n5, n2, n3, nArray2[6], 11);
        n3 = Md4Handler.HH(n3, n4, n5, n2, nArray2[14], 15);
        n2 = Md4Handler.HH(n2, n3, n4, n5, nArray2[1], 3);
        n5 = Md4Handler.HH(n5, n2, n3, n4, nArray2[9], 9);
        n4 = Md4Handler.HH(n4, n5, n2, n3, nArray2[5], 11);
        n3 = Md4Handler.HH(n3, n4, n5, n2, nArray2[13], 15);
        n2 = Md4Handler.HH(n2, n3, n4, n5, nArray2[3], 3);
        n5 = Md4Handler.HH(n5, n2, n3, n4, nArray2[11], 9);
        n4 = Md4Handler.HH(n4, n5, n2, n3, nArray2[7], 11);
        n3 = Md4Handler.HH(n3, n4, n5, n2, nArray2[15], 15);
        nArray[0] = nArray[0] + n2;
        nArray[1] = nArray[1] + n3;
        nArray[2] = nArray[2] + n4;
        nArray[3] = nArray[3] + n5;
    }

    public void analyzeInit() {
        this.count = new int[]{0, 0};
        this.state = new int[]{1732584193, -271733879, -1732584194, 271733878};
        this.buffer = new byte[64];
    }

    public void analyzeUpdate(byte[] byArray, int n) {
        this.analyzeUpdate(byArray, 0, n);
    }

    public void analyzeUpdate(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = this.count[0] >> 3 & 0x3F;
        this.count[0] = this.count[0] + (n2 << 3);
        if (this.count[0] < n2 << 3) {
            this.count[1] = this.count[1] + 1;
        }
        this.count[1] = this.count[1] + (n2 >> 29);
        int n5 = 64 - n4;
        if (n5 <= n2) {
            System.arraycopy(byArray, n, this.buffer, n4, n5);
            Md4Handler.md4Transform(this.state, this.buffer, 0);
            n3 = n5;
            while (n3 + 63 < n2) {
                Md4Handler.md4Transform(this.state, byArray, n3 + n);
                n3 += 64;
            }
            n4 = 0;
        } else {
            n3 = 0;
        }
        System.arraycopy(byArray, n3 + n, this.buffer, n4, n2 - n3);
    }

    public byte[] analyzeFinal() {
        byte[] byArray = new byte[8];
        Md4Handler.encode(byArray, this.count, 8);
        int n = this.count[0] >> 3 & 0x3F;
        int n2 = n < 56 ? 56 - n : 120 - n;
        this.analyzeUpdate(PADDING, n2);
        this.analyzeUpdate(byArray, 8);
        byte[] byArray2 = new byte[16];
        Md4Handler.encode(byArray2, this.state, 16);
        return byArray2;
    }
}

