/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.client.ArchiveFailureException;
import freenet.client.ArchiveKey;
import freenet.client.ArchiveStoreContext;
import freenet.client.ArchiveStoreItem;
import freenet.keys.FreenetURI;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.MultiReaderBucket;

class RealArchiveStoreItem
extends ArchiveStoreItem {
    private final MultiReaderBucket mb;
    private final Bucket bucket;
    private final long spaceUsed;
    private static volatile boolean logMINOR;

    RealArchiveStoreItem(ArchiveStoreContext ctx, FreenetURI key2, String realName, Bucket bucket) {
        super(new ArchiveKey(key2, realName), ctx);
        if (bucket == null) {
            throw new NullPointerException();
        }
        this.mb = new MultiReaderBucket(bucket);
        this.bucket = this.mb.getReaderBucket();
        if (this.bucket == null) {
            throw new NullPointerException();
        }
        this.bucket.setReadOnly();
        this.spaceUsed = this.bucket.size();
    }

    Bucket dataAsBucket() {
        return this.bucket;
    }

    long dataSize() {
        return this.bucket.size();
    }

    @Override
    long spaceUsed() {
        return this.spaceUsed;
    }

    @Override
    void innerClose() {
        if (logMINOR) {
            Logger.minor(this, "innerClose(): " + this + " : " + this.bucket);
        }
        if (this.bucket == null) {
            Logger.error(this, "IMPOSSIBLE: BUCKET IS NULL!", (Throwable)new Exception("error"));
            return;
        }
        this.bucket.free();
    }

    @Override
    Bucket getDataOrThrow() throws ArchiveFailureException {
        return this.dataAsBucket();
    }

    @Override
    Bucket getReaderBucket() throws ArchiveFailureException {
        return this.mb.getReaderBucket();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

