/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.ClientContext;
import freenet.client.async.PersistentJob;
import freenet.client.async.PersistentJobRunnerImpl;
import freenet.client.async.PersistentStatsPutter;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.RequestIdentifier;
import freenet.crypt.CRCChecksumChecker;
import freenet.crypt.ChecksumChecker;
import freenet.crypt.ChecksumFailedException;
import freenet.node.DatabaseKey;
import freenet.node.MasterKeysWrongPasswordException;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.NodeInitException;
import freenet.node.RequestStarterGroup;
import freenet.support.Executor;
import freenet.support.Logger;
import freenet.support.Ticker;
import freenet.support.api.Bucket;
import freenet.support.io.DelayedFree;
import freenet.support.io.FileBucket;
import freenet.support.io.FileUtil;
import freenet.support.io.PersistentTempBucketFactory;
import freenet.support.io.PrependLengthOutputStream;
import freenet.support.io.StorageFormatException;
import freenet.support.io.TempBucketFactory;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class ClientLayerPersister
extends PersistentJobRunnerImpl {
    static final long INTERVAL = TimeUnit.MINUTES.toMillis(10L);
    private final Node node;
    private final NodeClientCore clientCore;
    private final PersistentTempBucketFactory persistentTempFactory;
    private final TempBucketFactory tempBucketFactory;
    private final PersistentStatsPutter bandwidthStatsPutter;
    private byte[] salt;
    private boolean newSalt;
    private final ChecksumChecker checker;
    private Bucket writeToBucket;
    private File writeToFilename;
    private File writeToBackupFilename;
    private File deleteAfterSuccessfulWrite;
    private File otherDeleteAfterSuccessfulWrite;
    private File dir;
    private String baseName;
    private static final long MAGIC = -3228357045133554963L;
    private static final int VERSION = 1;
    private static volatile boolean logMINOR;

    public ClientLayerPersister(Executor executor, Ticker ticker, Node node, NodeClientCore core, PersistentTempBucketFactory persistentTempFactory, TempBucketFactory tempBucketFactory, PersistentStatsPutter stats) {
        super(executor, ticker, INTERVAL);
        this.node = node;
        this.clientCore = core;
        this.persistentTempFactory = persistentTempFactory;
        this.tempBucketFactory = tempBucketFactory;
        this.checker = new CRCChecksumChecker();
        this.bandwidthStatsPutter = stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilesAndLoad(File dir, String baseName, boolean writeEncrypted, boolean noWrite, DatabaseKey encryptionKey, ClientContext context, RequestStarterGroup requestStarters, Random random) throws MasterKeysWrongPasswordException {
        if (noWrite) {
            super.disableWrite();
        }
        Object object = this.serializeCheckpoints;
        synchronized (object) {
            this.dir = dir;
            this.baseName = baseName;
            if (noWrite) {
                this.writeToBucket = null;
                this.writeToFilename = null;
                this.writeToBackupFilename = null;
                this.deleteFile(dir, baseName, false, false);
                this.deleteFile(dir, baseName, false, true);
                this.deleteFile(dir, baseName, true, false);
                this.deleteFile(dir, baseName, true, true);
                this.onStarted(true);
                if (this.salt == null) {
                    this.salt = new byte[32];
                    random.nextBytes(this.salt);
                    requestStarters.setGlobalSalt(this.salt);
                }
            } else if (!this.hasLoaded()) {
                if (this.innerSetFilesAndLoad(false, dir, baseName, writeEncrypted, encryptionKey, context, requestStarters, random)) {
                    Logger.error(this, "Some requests failed to restart after serializing. Trying to recover/restart ...");
                    System.err.println("Some requests failed to restart after serializing. Trying to recover/restart ...");
                    this.innerSetFilesAndLoad(true, dir, baseName, writeEncrypted, encryptionKey, context, requestStarters, random);
                }
                this.onStarted(noWrite);
            } else {
                this.innerSetFilesOnly(dir, baseName, writeEncrypted, encryptionKey);
                this.onStarted(false);
            }
        }
    }

    private void deleteFile(File dir, String baseName, boolean backup, boolean encrypted) {
        block2: {
            File f = this.makeFilename(dir, baseName, backup, encrypted);
            try {
                FileUtil.secureDelete(f);
            }
            catch (IOException e) {
                f.delete();
                if (!f.exists()) break block2;
                System.err.println("Failed to delete " + f + " when setting maximum security level.");
                System.err.println("There may be traces on disk of your previous download queue.");
            }
        }
    }

    private void innerSetFilesOnly(File dir, String baseName, boolean writeEncrypted, DatabaseKey encryptionKey) throws MasterKeysWrongPasswordException {
        if (writeEncrypted && encryptionKey == null) {
            throw new MasterKeysWrongPasswordException();
        }
        File oldWriteToFilename = this.writeToFilename;
        this.writeToBucket = this.makeBucket(dir, baseName, false, writeEncrypted ? encryptionKey : null);
        this.writeToFilename = this.makeFilename(dir, baseName, false, writeEncrypted);
        this.writeToBackupFilename = this.makeFilename(dir, baseName, true, writeEncrypted);
        if (this.writeToFilename.equals(oldWriteToFilename)) {
            return;
        }
        System.out.println("Will save downloads to " + this.writeToFilename);
        this.deleteAfterSuccessfulWrite = this.makeFilename(dir, baseName, false, !writeEncrypted);
        this.otherDeleteAfterSuccessfulWrite = this.makeFilename(dir, baseName, true, !writeEncrypted);
        this.queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                return true;
            }
        });
    }

    private boolean innerSetFilesAndLoad(boolean noSerialize, File dir, String baseName, boolean writeEncrypted, DatabaseKey encryptionKey, ClientContext context, RequestStarterGroup requestStarters, Random random) throws MasterKeysWrongPasswordException {
        if (writeEncrypted && encryptionKey == null) {
            throw new MasterKeysWrongPasswordException();
        }
        File clientDat = new File(dir, baseName);
        File clientDatCrypt = new File(dir, baseName + ".crypt");
        File clientDatBak = new File(dir, baseName + ".bak");
        File clientDatBakCrypt = new File(dir, baseName + ".bak.crypt");
        boolean clientDatExists = clientDat.exists();
        boolean clientDatCryptExists = clientDatCrypt.exists();
        boolean clientDatBakExists = clientDatBak.exists();
        boolean clientDatBakCryptExists = clientDatBakCrypt.exists();
        if (encryptionKey == null && (clientDatCryptExists || clientDatBakCryptExists)) {
            throw new MasterKeysWrongPasswordException();
        }
        boolean failedSerialize = false;
        PartialLoad loaded = new PartialLoad();
        if (clientDatExists) {
            this.innerLoad(loaded, this.makeBucket(dir, baseName, false, null), noSerialize, context, requestStarters, random);
        }
        if (clientDatCryptExists && loaded.needsMore()) {
            this.innerLoad(loaded, this.makeBucket(dir, baseName, false, encryptionKey), noSerialize, context, requestStarters, random);
        }
        if (clientDatBakExists) {
            this.innerLoad(loaded, this.makeBucket(dir, baseName, true, null), noSerialize, context, requestStarters, random);
        }
        if (clientDatBakCryptExists && loaded.needsMore()) {
            this.innerLoad(loaded, this.makeBucket(dir, baseName, true, encryptionKey), noSerialize, context, requestStarters, random);
        }
        this.deleteAfterSuccessfulWrite = writeEncrypted ? clientDat : clientDatCrypt;
        this.otherDeleteAfterSuccessfulWrite = writeEncrypted ? clientDatBak : clientDatBakCrypt;
        this.writeToBucket = this.makeBucket(dir, baseName, false, writeEncrypted ? encryptionKey : null);
        this.writeToFilename = this.makeFilename(dir, baseName, false, writeEncrypted);
        this.writeToBackupFilename = this.makeFilename(dir, baseName, true, writeEncrypted);
        if (loaded.doneSomething()) {
            if (!noSerialize) {
                this.onLoading();
                if (loaded.getSalt() == null) {
                    this.salt = new byte[32];
                    random.nextBytes(this.salt);
                    Logger.error(this, "Checksum failed for salt value");
                    System.err.println("Salt value corrupted, downloads will need to regenerate Bloom filters, this may cause some delay and disk/CPU usage...");
                    this.newSalt = true;
                } else {
                    this.salt = loaded.salt;
                }
            }
            int success = 0;
            int restoredRestarted = 0;
            int restoredFully = 0;
            int failed = 0;
            for (PartiallyLoadedRequest partial : loaded.partiallyLoadedRequests.values()) {
                ClientRequest req = partial.request;
                if (req == null) continue;
                try {
                    req.onResume(context);
                    if (partial.status == RequestLoadStatus.RESTORED_FULLY || partial.status == RequestLoadStatus.RESTORED_RESTARTED) {
                        req.start(context);
                    }
                    switch (partial.status) {
                        case LOADED: {
                            ++success;
                            break;
                        }
                        case RESTORED_FULLY: {
                            ++restoredFully;
                            break;
                        }
                        case RESTORED_RESTARTED: {
                            ++restoredRestarted;
                            break;
                        }
                        case FAILED: {
                            ++failed;
                        }
                    }
                }
                catch (Throwable t) {
                    if (partial.status == RequestLoadStatus.LOADED) {
                        failedSerialize = true;
                    }
                    ++failed;
                    System.err.println("Unable to resume request " + req + " after loading it.");
                    Logger.error(this, "Unable to resume request " + req + " after loading it: " + t, t);
                    try {
                        req.cancel(context);
                    }
                    catch (Throwable t1) {
                        Logger.error(this, "Unable to terminate " + req + " after failure: " + t1, t1);
                    }
                }
            }
            if (success > 0) {
                System.out.println("Resumed " + success + " requests ...");
            }
            if (restoredFully > 0) {
                System.out.println("Restored " + restoredFully + " requests (in spite of data corruption)");
            }
            if (restoredRestarted > 0) {
                System.out.println("Restarted " + restoredRestarted + " requests (due to data corruption)");
            }
            if (failed > 0) {
                System.err.println("Failed to restore " + failed + " requests due to data corruption");
            }
            return failedSerialize;
        }
        System.err.println("Starting request persistence layer without resuming ...");
        this.salt = new byte[32];
        random.nextBytes(this.salt);
        requestStarters.setGlobalSalt(this.salt);
        this.onStarted(false);
        return false;
    }

    private Bucket makeBucket(File dir, String baseName, boolean backup, DatabaseKey encryptionKey) {
        File filename = this.makeFilename(dir, baseName, backup, encryptionKey != null);
        Bucket bucket = new FileBucket(filename, false, false, false, false);
        if (encryptionKey != null) {
            bucket = encryptionKey.createEncryptedBucketForClientLayer(bucket);
        }
        return bucket;
    }

    private File makeFilename(File parent, String baseName, boolean backup, boolean encrypted) {
        return new File(parent, baseName + (backup ? ".bak" : "") + (encrypted ? ".crypt" : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerLoad(PartialLoad loaded, Bucket bucket, boolean noSerialize, ClientContext context, RequestStarterGroup requestStarters, Random random) {
        long length = bucket.size();
        InputStream fis = null;
        try {
            fis = bucket.getInputStream();
            this.innerLoad(loaded, fis, length, !noSerialize && !loaded.doneSomething(), context, requestStarters, random, noSerialize);
        }
        catch (IOException e) {
            Logger.error(this, "Failed to load persistent requests from " + bucket + " : " + e, (Throwable)e);
            System.err.println("Failed to load persistent requests from " + bucket + " : " + e);
            e.printStackTrace();
            loaded.setSomethingFailed();
        }
        catch (Throwable t) {
            Logger.error(this, "Failed to load persistent requests from " + bucket + " : " + t, t);
            System.err.println("Failed to load persistent requests from " + bucket + " : " + t);
            t.printStackTrace();
            loaded.setSomethingFailed();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                System.err.println("Failed to load persistent requests: " + e);
                e.printStackTrace();
            }
        }
    }

    private void innerLoad(PartialLoad loaded, InputStream fis, long length, boolean latest, ClientContext context, RequestStarterGroup requestStarters, Random random, boolean noSerialize) throws NodeInitException, IOException {
        ObjectInputStream ois = new ObjectInputStream(fis);
        long magic = ois.readLong();
        if (magic != -3228357045133554963L) {
            throw new IOException("Bad magic");
        }
        int version = ois.readInt();
        if (version != 1) {
            throw new IOException("Bad version");
        }
        byte[] salt = new byte[32];
        try {
            this.checker.readAndChecksum(ois, salt, 0, salt.length);
            loaded.setSalt(salt);
        }
        catch (ChecksumFailedException e1) {
            Logger.error(this, "Unable to read global salt (checksum failed)");
        }
        requestStarters.setGlobalSalt(salt);
        int requestCount = ois.readInt();
        for (int i = 0; i < requestCount; ++i) {
            ClientRequest request = null;
            RequestIdentifier reqID = this.readRequestIdentifier(ois);
            if (reqID != null && context.persistentRoot.hasRequest(reqID)) {
                Logger.warning(this, "Not reading request because already have it");
                this.skipChecksummedObject(ois, length);
                this.skipChecksummedObject(ois, length);
                continue;
            }
            try {
                if (!noSerialize) {
                    request = (ClientRequest)this.readChecksummedObject(ois, length);
                    if (request != null && reqID != null) {
                        if (!reqID.sameIdentifier(request.getRequestIdentifier())) {
                            Logger.error(this, "Request does not match request identifier, discarding");
                            request = null;
                        } else {
                            loaded.addPartiallyLoadedRequest(reqID, request, RequestLoadStatus.LOADED);
                        }
                    }
                } else {
                    this.skipChecksummedObject(ois, length);
                }
            }
            catch (ChecksumFailedException e) {
                Logger.error(this, "Failed to load request (checksum failed)");
                System.err.println("Failed to load a request (checksum failed)");
            }
            catch (Throwable t) {
                Logger.error(this, "Failed to load request: " + t, t);
                System.err.println("Failed to load a request: " + t);
                t.printStackTrace();
            }
            if (request == null || logMINOR) {
                try {
                    ClientRequest restored = this.readRequestFromRecoveryData(ois, length, reqID);
                    if (request != null || restored == null) continue;
                    request = restored;
                    boolean loadedFully = restored.fullyResumed();
                    loaded.addPartiallyLoadedRequest(reqID, request, loadedFully ? RequestLoadStatus.RESTORED_FULLY : RequestLoadStatus.RESTORED_RESTARTED);
                }
                catch (ChecksumFailedException e) {
                    if (request == null) {
                        Logger.error(this, "Failed to recover a request (checksum failed)");
                        System.err.println("Failed to recover a request (checksum failed)");
                    } else {
                        Logger.error(this, "Test recovery failed: Checksum failed for " + reqID);
                    }
                    if (request != null) continue;
                    loaded.addPartiallyLoadedRequest(reqID, null, RequestLoadStatus.FAILED);
                }
                catch (StorageFormatException e) {
                    if (request == null) {
                        Logger.error(this, "Failed to recovery a request (storage format): " + e, (Throwable)e);
                        System.err.println("Failed to recovery a request (storage format): " + e);
                        e.printStackTrace();
                    } else {
                        Logger.error(this, "Test recovery failed for " + reqID + " : " + e, (Throwable)e);
                    }
                    if (request != null) continue;
                    loaded.addPartiallyLoadedRequest(reqID, null, RequestLoadStatus.FAILED);
                }
                continue;
            }
            this.skipChecksummedObject(ois, length);
        }
        if (latest) {
            try {
                this.readStatsAndBuckets(ois, length, context);
            }
            catch (Throwable t) {
                Logger.error(this, "Failed to restore stats and delete old temp files: " + t, t);
            }
        }
        ois.close();
        fis = null;
    }

    private void readStatsAndBuckets(ObjectInputStream ois, long length, ClientContext context) throws IOException, ClassNotFoundException {
        PersistentStatsPutter storedStatsPutter = (PersistentStatsPutter)ois.readObject();
        this.bandwidthStatsPutter.addFrom(storedStatsPutter);
        int count = ois.readInt();
        DelayedFree[] buckets = new DelayedFree[count];
        for (int i = 0; i < count; ++i) {
            try {
                buckets[i] = (DelayedFree)this.readChecksummedObject(ois, length);
                continue;
            }
            catch (ChecksumFailedException e) {
                Logger.warning(this, "Failed to load a bucket to free");
            }
        }
        this.persistentTempFactory.finishDelayedFree(buckets);
    }

    @Override
    protected void innerCheckpoint(boolean shutdown) {
        this.save(shutdown);
    }

    protected void save(boolean shutdown) {
        if (this.writeToFilename == null) {
            return;
        }
        if (this.writeToFilename.exists()) {
            FileUtil.renameTo(this.writeToFilename, this.writeToBackupFilename);
        }
        if (this.innerSave(shutdown)) {
            if (this.deleteAfterSuccessfulWrite != null) {
                this.deleteAfterSuccessfulWrite.delete();
                this.deleteAfterSuccessfulWrite = null;
            }
            if (this.otherDeleteAfterSuccessfulWrite != null) {
                this.otherDeleteAfterSuccessfulWrite.delete();
                this.otherDeleteAfterSuccessfulWrite = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean innerSave(boolean shutdown) {
        DelayedFree[] buckets = this.persistentTempFactory.grabBucketsToFree();
        OutputStream fos = null;
        try {
            fos = this.writeToBucket.getOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeLong(-3228357045133554963L);
            oos.writeInt(1);
            this.checker.writeAndChecksum(oos, this.salt);
            ClientRequest[] requests = this.getRequests();
            if (shutdown) {
                for (ClientRequest req : requests) {
                    if (req == null) continue;
                    try {
                        req.onShutdown(this.getClientContext());
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught while calling shutdown callback on " + req + ": " + t, t);
                    }
                }
            }
            oos.writeInt(requests.length);
            for (ClientRequest req : requests) {
                this.writeRequestIdentifier(oos, req.getRequestIdentifier());
                this.writeChecksummedObject(oos, req, req.toString());
                this.writeRecoveryData(oos, req);
            }
            this.bandwidthStatsPutter.updateData(this.node);
            oos.writeObject(this.bandwidthStatsPutter);
            if (buckets == null) {
                oos.writeInt(0);
            } else {
                oos.writeInt(buckets.length);
                for (DelayedFree bucket : buckets) {
                    this.writeChecksummedObject(oos, bucket, null);
                }
            }
            oos.close();
            fos = null;
            Logger.normal(this, "Saved " + requests.length + " requests to " + this.writeToFilename);
            this.persistentTempFactory.finishDelayedFree(buckets);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            System.err.println("Failed to write persistent requests: " + e);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                System.err.println("Failed to write persistent requests: " + e);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRecoveryData(ObjectOutputStream os, ClientRequest req) throws IOException {
        PrependLengthOutputStream oos = this.checker.checksumWriterWithLength(os, this.tempBucketFactory);
        DataOutputStream dos = new DataOutputStream(oos);
        try {
            req.getClientDetail(dos, this.checker);
            dos.close();
            oos = null;
        }
        catch (Throwable e) {
            Logger.error(this, "Unable to write recovery data for " + req + " : " + e, e);
            System.err.println("Unable to write recovery data for " + req + " : " + e);
            e.printStackTrace();
            oos.abort();
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientRequest readRequestFromRecoveryData(ObjectInputStream is, long totalLength, RequestIdentifier reqID) throws IOException, ChecksumFailedException, StorageFormatException {
        try (InputStream tmp = this.checker.checksumReaderWithLength(is, this.tempBucketFactory, totalLength);){
            DataInputStream dis = new DataInputStream(tmp);
            ClientRequest request = ClientRequest.restartFrom(dis, reqID, this.getClientContext(), this.checker);
            dis.close();
            dis = null;
            tmp = null;
            ClientRequest clientRequest = request;
            return clientRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChecksummedObject(ObjectOutputStream os, Object req, String name) throws IOException {
        try (PrependLengthOutputStream oos = this.checker.checksumWriterWithLength(os, this.tempBucketFactory);){
            ObjectOutputStream innerOOS = new ObjectOutputStream(oos);
            innerOOS.writeObject(req);
            innerOOS.close();
            oos = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readChecksummedObject(ObjectInputStream is, long totalLength) throws IOException, ChecksumFailedException, ClassNotFoundException {
        try (InputStream ois = this.checker.checksumReaderWithLength(is, this.tempBucketFactory, totalLength);){
            ObjectInputStream oo = new ObjectInputStream(ois);
            Object ret = oo.readObject();
            oo.close();
            oo = null;
            ois = null;
            Object object = ret;
            return object;
        }
    }

    private void skipChecksummedObject(ObjectInputStream is, long totalLength) throws IOException {
        long length = is.readLong();
        if (length > totalLength) {
            throw new IOException("Too long: " + length + " > " + totalLength);
        }
        FileUtil.skipFully(is, length + (long)this.checker.checksumLength());
    }

    private ClientRequest[] getRequests() {
        return this.clientCore.getPersistentRequests();
    }

    @Override
    public boolean newSalt() {
        return this.newSalt;
    }

    private RequestIdentifier readRequestIdentifier(DataInput is) throws IOException {
        short length = is.readShort();
        if (length <= 0) {
            return null;
        }
        byte[] buf = new byte[length];
        try {
            this.checker.readAndChecksum(is, buf, 0, length);
        }
        catch (ChecksumFailedException e) {
            Logger.error(this, "Checksum failed reading RequestIdentifier. This is not serious but means we will have to read the next request even if we don't need it.");
            return null;
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buf));
        try {
            return new RequestIdentifier(dis);
        }
        catch (IOException e) {
            Logger.error(this, "Failed to parse RequestIdentifier in spite of valid checksum (probably a bug): " + e, (Throwable)e);
            return null;
        }
    }

    private void writeRequestIdentifier(DataOutput os, RequestIdentifier req) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream oos = this.checker.checksumWriter(baos);
        DataOutputStream dos = new DataOutputStream(oos);
        req.writeTo(dos);
        dos.close();
        byte[] buf = baos.toByteArray();
        os.writeShort(buf.length - this.checker.checksumLength());
        os.write(buf);
    }

    public synchronized File getWriteFilename() {
        return this.writeToFilename;
    }

    public void panic() {
        this.killAndWaitForNotWriting();
        this.deleteAllFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllFiles() {
        Object object = this.serializeCheckpoints;
        synchronized (object) {
            this.deleteFile(this.dir, this.baseName, false, false);
            this.deleteFile(this.dir, this.baseName, false, true);
            this.deleteFile(this.dir, this.baseName, true, false);
            this.deleteFile(this.dir, this.baseName, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableWrite() {
        Object object = this.serializeCheckpoints;
        synchronized (object) {
            this.writeToFilename = null;
            this.writeToBackupFilename = null;
            this.writeToBucket = null;
        }
        super.disableWrite();
    }

    static {
        Logger.registerClass(ClientLayerPersister.class);
    }

    private class PartialLoad {
        private final Map<RequestIdentifier, PartiallyLoadedRequest> partiallyLoadedRequests = new HashMap<RequestIdentifier, PartiallyLoadedRequest>();
        private byte[] salt;
        private boolean somethingFailed;
        private boolean doneSomething;

        private PartialLoad() {
        }

        void addPartiallyLoadedRequest(RequestIdentifier reqID, ClientRequest request, RequestLoadStatus status) {
            PartiallyLoadedRequest old;
            if (reqID == null) {
                if (request == null) {
                    this.somethingFailed = true;
                    return;
                }
                reqID = request.getRequestIdentifier();
            }
            if ((old = this.partiallyLoadedRequests.get(reqID)) == null || old.status.ordinal() > status.ordinal()) {
                this.partiallyLoadedRequests.put(reqID, new PartiallyLoadedRequest(request, status));
                if (status != RequestLoadStatus.LOADED && status != RequestLoadStatus.RESTORED_FULLY) {
                    this.somethingFailed = true;
                }
                this.doneSomething = true;
            }
        }

        public boolean needsMore() {
            return this.somethingFailed || !this.doneSomething;
        }

        public void setSomethingFailed() {
            this.somethingFailed = true;
        }

        public void setSalt(byte[] loadedSalt) {
            if (this.salt == null) {
                this.salt = loadedSalt;
            }
            this.doneSomething = true;
        }

        public byte[] getSalt() {
            return this.salt;
        }

        public boolean doneSomething() {
            return this.doneSomething;
        }
    }

    private class PartiallyLoadedRequest {
        final ClientRequest request;
        final RequestLoadStatus status;

        PartiallyLoadedRequest(ClientRequest request, RequestLoadStatus status) {
            this.request = request;
            this.status = status;
        }
    }

    private static enum RequestLoadStatus {
        LOADED,
        RESTORED_FULLY,
        RESTORED_RESTARTED,
        FAILED;

    }
}

