/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.N2NFeedMessage;
import freenet.keys.FreenetURI;
import freenet.support.SimpleFieldSet;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.ArrayBucket;
import freenet.support.io.NullBucket;
import java.io.UnsupportedEncodingException;

public class BookmarkFeed
extends N2NFeedMessage {
    public static final String NAME = "BookmarkFeed";
    private final String name;
    private final FreenetURI URI;
    private final boolean hasAnActivelink;

    public BookmarkFeed(String header, String shortText, String text, short priorityClass, long updatedTime, String sourceNodeName, long composed, long sent, long received, String name, FreenetURI URI2, String description, boolean hasAnActivelink) {
        super(header, shortText, text, priorityClass, updatedTime, sourceNodeName, composed, sent, received);
        RandomAccessBucket descriptionBucket;
        this.name = name;
        this.URI = URI2;
        this.hasAnActivelink = hasAnActivelink;
        try {
            descriptionBucket = description != null ? new ArrayBucket(description.getBytes("UTF-8")) : new NullBucket();
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
        this.buckets.put("Description", descriptionBucket);
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = super.getFieldSet();
        fs.putSingle("Name", this.name);
        fs.putSingle("URI", this.URI.toString());
        fs.put("HasAnActivelink", this.hasAnActivelink);
        return fs;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

