/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.PeerMessage;
import freenet.clients.fcp.UnknownNodeIdentifierMessage;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.support.SimpleFieldSet;

public class ListPeerMessage
extends FCPMessage {
    static final String NAME = "ListPeer";
    final SimpleFieldSet fs;
    final String identifier;

    public ListPeerMessage(SimpleFieldSet fs) {
        this.fs = fs;
        this.identifier = fs.get("Identifier");
        fs.removeValue("Identifier");
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        if (!handler.hasFullAccess()) {
            throw new MessageInvalidException(24, "ListPeer requires full access", this.identifier, false);
        }
        String nodeIdentifier = this.fs.get("NodeIdentifier");
        if (nodeIdentifier == null) {
            throw new MessageInvalidException(5, "Error: NodeIdentifier field missing", this.identifier, false);
        }
        PeerNode pn = node.getPeerNode(nodeIdentifier);
        if (pn == null) {
            UnknownNodeIdentifierMessage msg = new UnknownNodeIdentifierMessage(nodeIdentifier, this.identifier);
            handler.outputHandler.queue(msg);
            return;
        }
        handler.outputHandler.queue(new PeerMessage(pn, true, true, this.identifier));
    }
}

