/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.BaseDataCarryingMessage;
import freenet.clients.fcp.FCPServer;
import freenet.clients.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.BucketTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class MultipleDataCarryingMessage
extends BaseDataCarryingMessage {
    protected Map<String, Bucket> buckets = new LinkedHashMap<String, Bucket>();
    protected boolean freeOnSent;

    void setFreeOnSent() {
        this.freeOnSent = true;
    }

    @Override
    public void readFrom(InputStream is, BucketFactory bf, FCPServer server) throws IOException, MessageInvalidException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeData(OutputStream os) throws IOException {
        for (Map.Entry<String, Bucket> entry : this.buckets.entrySet()) {
            Bucket bucket = entry.getValue();
            BucketTools.copyTo(bucket, os, bucket.size());
            if (!this.freeOnSent) continue;
            bucket.free();
        }
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        int dataLength = 0;
        SimpleFieldSet fs = new SimpleFieldSet(true);
        for (Map.Entry<String, Bucket> entry : this.buckets.entrySet()) {
            String field = entry.getKey();
            Bucket bucket = entry.getValue();
            fs.put(field + "Length", bucket.size());
            dataLength = (int)((long)dataLength + bucket.size());
        }
        fs.put("DataLength", dataLength);
        return fs;
    }

    @Override
    public long dataLength() {
        int dataLength = 0;
        for (Bucket bucket : this.buckets.values()) {
            dataLength = (int)((long)dataLength + bucket.size());
        }
        return dataLength;
    }

    @Override
    String getEndString() {
        return "Data";
    }
}

