/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.DataCarryingMessage;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.SentPeerMessage;
import freenet.clients.fcp.UnknownNodeIdentifierMessage;
import freenet.node.DarknetPeerNode;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.support.SimpleFieldSet;

public abstract class SendPeerMessage
extends DataCarryingMessage {
    protected final String identifier;
    protected final String nodeIdentifier;
    private final long dataLength;

    public SendPeerMessage(SimpleFieldSet fs) throws MessageInvalidException {
        block4: {
            this.identifier = fs.get("Identifier");
            this.nodeIdentifier = fs.get("NodeIdentifier");
            String dataLengthString = fs.get("DataLength");
            if (dataLengthString != null) {
                try {
                    this.dataLength = Long.parseLong(dataLengthString, 10);
                    if (this.dataLength < 0L) {
                        throw new Exception();
                    }
                    break block4;
                }
                catch (Exception e) {
                    throw new MessageInvalidException(8, "Invalid DataLength field", this.identifier, false);
                }
            }
            this.dataLength = -1L;
        }
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        fs.putSingle("NodeIdentifier", this.nodeIdentifier);
        if (this.dataLength >= 0L) {
            fs.put("DataLength", this.dataLength);
        }
        return fs;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        PeerNode pn = node.getPeerNode(this.nodeIdentifier);
        if (pn == null) {
            UnknownNodeIdentifierMessage msg = new UnknownNodeIdentifierMessage(this.nodeIdentifier, this.identifier);
            handler.outputHandler.queue(msg);
        } else {
            if (!(pn instanceof DarknetPeerNode)) {
                throw new MessageInvalidException(31, this.getName() + " only available for darknet peers", this.identifier, false);
            }
            int nodeStatus = this.handleFeed((DarknetPeerNode)pn);
            handler.outputHandler.queue(new SentPeerMessage(this.identifier, nodeStatus));
        }
    }

    protected abstract int handleFeed(DarknetPeerNode var1) throws MessageInvalidException;

    @Override
    String getIdentifier() {
        return null;
    }

    @Override
    boolean isGlobal() {
        return false;
    }

    @Override
    long dataLength() {
        return this.dataLength;
    }
}

