/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.StaticToadlet;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.clients.http.WelcomeToadlet;
import freenet.l10n.NodeL10n;
import freenet.support.HTMLNode;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.net.URI;

public class StartupToadlet
extends Toadlet {
    private StaticToadlet staticToadlet;
    private volatile boolean isPRNGReady = false;

    public StartupToadlet(StaticToadlet staticToadlet) {
        super(null);
        this.staticToadlet = staticToadlet;
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest req, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        ctx.forceDisconnect();
        String path = uri.getPath();
        if (path.startsWith("/static/") && this.staticToadlet != null) {
            this.staticToadlet.handleMethodGET(uri, req, ctx);
        } else {
            String desc = NodeL10n.getBase().getString("StartupToadlet.title");
            PageNode page = ctx.getPageMaker().getPageNode(desc, ctx, new PageMaker.RenderParameters().renderStatus(false).renderNavigationLinks(false).renderModeSwitch(false));
            HTMLNode pageNode = page.outer;
            HTMLNode headNode = page.headNode;
            headNode.addChild("meta", new String[]{"http-equiv", "content"}, new String[]{"refresh", "1; url="});
            HTMLNode contentNode = page.content;
            if (!this.isPRNGReady) {
                HTMLNode prngInfoboxContent = ctx.getPageMaker().getInfobox("infobox-error", NodeL10n.getBase().getString("StartupToadlet.entropyErrorTitle"), contentNode, null, true);
                prngInfoboxContent.addChild("#", NodeL10n.getBase().getString("StartupToadlet.entropyErrorContent"));
            }
            HTMLNode infoboxContent = ctx.getPageMaker().getInfobox("infobox-error", desc, contentNode, null, true);
            infoboxContent.addChild("#", NodeL10n.getBase().getString("StartupToadlet.isStartingUp"));
            WelcomeToadlet.maybeDisplayWrapperLogfile(ctx, contentNode);
            this.writeHTMLReply(ctx, 503, desc, pageNode.generate());
        }
    }

    public void setIsPRNGReady() {
        this.isPRNGReady = true;
    }

    @Override
    public String path() {
        return "/";
    }
}

