/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.DefaultMIMETypes;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.NodeL10n;
import freenet.support.api.HTTPRequest;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.FileBucket;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Date;

public class StaticToadlet
extends Toadlet {
    public static final String ROOT_URL = "/static/";
    public static final String ROOT_PATH = "staticfiles/";
    public static final String OVERRIDE = "override/";
    public static final String OVERRIDE_URL = "/static/override/";

    StaticToadlet() {
        super(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        String path = uri.getPath();
        if (!path.startsWith(ROOT_URL)) {
            return;
        }
        try {
            path = path.substring(ROOT_URL.length());
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.sendErrorPage(ctx, 404, this.l10n("pathNotFoundTitle"), this.l10n("pathNotFound"));
            return;
        }
        if (!path.matches("^[A-Za-z0-9\\._\\/\\-]*$") || path.indexOf("..") != -1) {
            this.sendErrorPage(ctx, 404, this.l10n("pathNotFoundTitle"), this.l10n("pathInvalidChars"));
            return;
        }
        if (path.startsWith(OVERRIDE)) {
            File f = this.container.getOverrideFile();
            if (f == null || !f.exists() || f.isDirectory() || !f.isFile()) {
                this.sendErrorPage(ctx, 404, this.l10n("pathNotFoundTitle"), this.l10n("pathInvalidChars"));
                return;
            }
            if ((f = f.getAbsoluteFile()) == null || !f.exists() || f.isDirectory() || !f.isFile()) {
                this.sendErrorPage(ctx, 404, this.l10n("pathNotFoundTitle"), this.l10n("pathInvalidChars"));
                return;
            }
            File parent = f.getParentFile();
            if (parent.getParentFile() == null) {
                this.sendErrorPage(ctx, 404, this.l10n("pathNotFoundTitle"), this.l10n("pathInvalidChars"));
                return;
            }
            File from = new File(parent, path.substring(OVERRIDE.length()));
            if (!from.exists() && !from.isFile()) {
                this.sendErrorPage(ctx, 404, this.l10n("pathNotFoundTitle"), this.l10n("pathInvalidChars"));
                return;
            }
            try {
                FileBucket fb = new FileBucket(from, true, false, false, false);
                ctx.sendReplyHeadersStatic(200, "OK", null, DefaultMIMETypes.guessMIMEType(path, false), fb.size(), new Date(System.currentTimeMillis() - 1000L));
                ctx.writeData(fb);
                return;
            }
            catch (IOException e) {
                this.sendErrorPage(ctx, 404, this.l10n("pathNotFoundTitle"), this.l10n("pathNotFound"));
                return;
            }
        }
        InputStream strm = this.getClass().getResourceAsStream(ROOT_PATH + path);
        if (strm == null) {
            this.sendErrorPage(ctx, 404, this.l10n("pathNotFoundTitle"), this.l10n("pathNotFound"));
            return;
        }
        RandomAccessBucket data = ctx.getBucketFactory().makeBucket(strm.available());
        OutputStream os = data.getOutputStream();
        try {
            int r;
            byte[] cbuf = new byte[4096];
            while ((r = strm.read(cbuf)) != -1) {
                os.write(cbuf, 0, r);
            }
        }
        finally {
            strm.close();
            os.close();
        }
        URL url = this.getClass().getResource(ROOT_PATH + path);
        Date mTime = this.getUrlMTime(url);
        ctx.sendReplyHeadersStatic(200, "OK", null, DefaultMIMETypes.guessMIMEType(path, false), data.size(), mTime);
        ctx.writeData(data);
    }

    private Date getUrlMTime(URL url) {
        if (url.getProtocol().equals("jar")) {
            File f = new File(url.getPath().substring(0, url.getPath().indexOf(33)));
            return new Date(f.lastModified());
        }
        if (url.getProtocol().equals("file")) {
            File f = new File(url.getPath());
            return new Date(f.lastModified());
        }
        return null;
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("StaticToadlet." + key);
    }

    @Override
    public String path() {
        return ROOT_URL;
    }

    public static boolean haveFile(String path) {
        URL url = StaticToadlet.class.getResource(ROOT_PATH + path);
        return url != null;
    }
}

