/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.BlockCipher;

public class CTRBlockCipher {
    private final BlockCipher cipher;
    private final int blockSize;
    private final byte[] IV;
    private final byte[] counter;
    private final byte[] counterOut;
    private int blockOffset;

    public CTRBlockCipher(BlockCipher c) {
        this.cipher = c;
        this.blockSize = this.cipher.getBlockSize() / 8;
        this.IV = new byte[this.blockSize];
        this.counter = new byte[this.blockSize];
        this.counterOut = new byte[this.blockSize];
        this.blockOffset = this.IV.length;
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public void init(byte[] iv, int offset, int length) throws IllegalArgumentException {
        if (length != this.IV.length) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(iv, offset, this.IV, 0, this.IV.length);
        System.arraycopy(this.IV, 0, this.counter, 0, this.counter.length);
        this.processBlock();
    }

    public void init(byte[] iv) throws IllegalArgumentException {
        this.init(iv, 0, iv.length);
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public byte processByte(byte in) {
        if (this.blockOffset == this.counterOut.length) {
            this.processBlock();
        }
        return (byte)(in ^ this.counterOut[this.blockOffset++]);
    }

    public void processBytes(byte[] input, int offsetIn, int length, byte[] output, int offsetOut) {
        if (this.blockOffset != 0) {
            int len = Math.min(this.blockSize - this.blockOffset, length);
            length -= len;
            while (len-- > 0) {
                output[offsetOut++] = (byte)(input[offsetIn++] ^ this.counterOut[this.blockOffset++]);
            }
            if (length == 0) {
                return;
            }
            this.processBlock();
        }
        assert (this.blockOffset == 0);
        while (length > this.blockSize) {
            length -= this.blockSize;
            while (this.blockOffset < this.blockSize) {
                output[offsetOut++] = (byte)(input[offsetIn++] ^ this.counterOut[this.blockOffset++]);
            }
            this.processBlock();
        }
        assert (this.blockOffset == 0 && length <= this.blockSize);
        if (length == 0) {
            return;
        }
        while (length-- > 0) {
            output[offsetOut++] = (byte)(input[offsetIn++] ^ this.counterOut[this.blockOffset++]);
        }
    }

    private void processBlock() throws IllegalStateException {
        System.arraycopy(this.counter, 0, this.counterOut, 0, this.counter.length);
        this.cipher.encipher(this.counterOut, this.counterOut);
        int i = this.counter.length;
        while (i-- > 0) {
            int n = i;
            this.counter[n] = (byte)(this.counter[n] + 1);
            if (this.counter[n] == 0) continue;
        }
        this.blockOffset = 0;
    }
}

