/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.KeyType;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;

public enum MACType {
    HMACSHA256(1, "HmacSHA256", KeyType.HMACSHA256),
    HMACSHA384(2, "HmacSHA384", KeyType.HMACSHA384),
    HMACSHA512(2, "HmacSHA512", KeyType.HMACSHA512),
    Poly1305AES(2, "POLY1305-AES", 16, KeyType.POLY1305AES);

    public final int bitmask;
    public final String mac;
    public final int ivlen;
    public final KeyType keyType;

    private MACType(int bitmask, String mac, KeyType type) {
        this.bitmask = bitmask;
        this.mac = mac;
        this.ivlen = -1;
        this.keyType = type;
    }

    private MACType(int bitmask, String mac, int ivlen, KeyType type) {
        this.bitmask = bitmask;
        this.mac = mac;
        this.ivlen = ivlen;
        this.keyType = type;
    }

    public final Mac get() {
        try {
            return Mac.getInstance(this.mac);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
    }
}

