/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.HashResult;
import freenet.crypt.HashType;
import freenet.support.Logger;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public class MultiHashOutputStream
extends FilterOutputStream {
    private Digester[] digesters;

    public MultiHashOutputStream(OutputStream proxy, long generateHashes) {
        super(proxy);
        ArrayList<Digester> digesters = new ArrayList<Digester>();
        for (HashType type : HashType.values()) {
            if ((generateHashes & (long)type.bitmask) != (long)type.bitmask) continue;
            try {
                digesters.add(new Digester(type));
            }
            catch (NoSuchAlgorithmException e) {
                Logger.error(this, "Algorithm not available: " + (Object)((Object)type));
            }
        }
        this.digesters = digesters.toArray(new Digester[digesters.size()]);
    }

    @Override
    public void write(int arg0) throws IOException {
        this.out.write(arg0);
        for (Digester d : this.digesters) {
            d.digest.update(new byte[]{(byte)arg0});
        }
    }

    @Override
    public void write(byte[] arg0) throws IOException {
        this.out.write(arg0);
        for (Digester d : this.digesters) {
            d.digest.update(arg0);
        }
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) throws IOException {
        this.out.write(arg0, arg1, arg2);
        for (Digester d : this.digesters) {
            d.digest.update(arg0, arg1, arg2);
        }
    }

    public HashResult[] getResults() {
        HashResult[] results = new HashResult[this.digesters.length];
        for (int i = 0; i < this.digesters.length; ++i) {
            results[i] = this.digesters[i].getResult();
        }
        this.digesters = null;
        return results;
    }

    class Digester {
        HashType hashType;
        MessageDigest digest;

        Digester(HashType hashType) throws NoSuchAlgorithmException {
            this.hashType = hashType;
            this.digest = hashType.get();
        }

        HashResult getResult() {
            HashResult result = new HashResult(this.hashType, this.digest.digest());
            this.hashType.recycle(this.digest);
            this.digest = null;
            return result;
        }
    }
}

