/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.Location;
import freenet.node.Node;
import freenet.node.Version;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.math.TrivialRunningAverage;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class HourlyStatsRecord {
    private static final int N_DISTANCE_GROUPS = 16;
    private final boolean completeHour;
    private boolean finishedReporting;
    private StatsLine[] byHTL;
    private StatsLine[] byDist;
    private Date beginTime;
    private final Node node;
    private static SimpleDateFormat utcDateTime = new SimpleDateFormat("yyyyMMdd HH:mm:ss.SSS");
    private static final DecimalFormat fix3p3pct;
    private static final DecimalFormat fix4p;

    public HourlyStatsRecord(Node node, boolean completeHour) {
        int i;
        this.node = node;
        this.completeHour = completeHour;
        this.finishedReporting = false;
        this.byHTL = new StatsLine[node.maxHTL() + 1];
        for (i = 0; i < this.byHTL.length; ++i) {
            this.byHTL[i] = new StatsLine();
        }
        this.byDist = new StatsLine[16];
        for (i = 0; i < this.byDist.length; ++i) {
            this.byDist[i] = new StatsLine();
        }
        this.beginTime = new Date();
    }

    public synchronized void markFinal() {
        this.finishedReporting = true;
    }

    public synchronized void remoteRequest(boolean ssk, boolean success, boolean local, int htl, double location) {
        if (this.finishedReporting) {
            throw new IllegalStateException("Attempted to modify completed stats record.");
        }
        if (htl < 0) {
            throw new IllegalArgumentException("Invalid HTL.");
        }
        if (location < 0.0 || location > 1.0) {
            throw new IllegalArgumentException("Invalid location.");
        }
        htl = Math.min(htl, this.node.maxHTL());
        double rawDist = Location.distance(this.node.getLocation(), location);
        if (rawDist <= 0.0) {
            rawDist = Double.MIN_VALUE;
        }
        double logDist = Math.log(rawDist) / Math.log(2.0);
        assert (logDist < -1.0);
        int distBucket = (int)Math.floor(-1.0 * logDist);
        if (distBucket >= this.byDist.length) {
            distBucket = this.byDist.length - 1;
        }
        if (ssk) {
            this.byHTL[htl].locDiffSSK.report(logDist);
        } else {
            this.byHTL[htl].locDiffCHK.report(logDist);
        }
        if (success) {
            if (ssk) {
                if (local) {
                    this.byHTL[htl].sskLocalSuccess.report(logDist);
                    this.byDist[distBucket].sskLocalSuccess.report(htl);
                } else {
                    this.byHTL[htl].sskRemoteSuccess.report(logDist);
                    this.byDist[distBucket].sskRemoteSuccess.report(htl);
                }
            } else if (local) {
                this.byHTL[htl].chkLocalSuccess.report(logDist);
                this.byDist[distBucket].chkLocalSuccess.report(htl);
            } else {
                this.byHTL[htl].chkRemoteSuccess.report(logDist);
                this.byDist[distBucket].chkRemoteSuccess.report(htl);
            }
        } else if (ssk) {
            this.byHTL[htl].sskFailure.report(logDist);
            this.byDist[distBucket].sskFailure.report(htl);
        } else {
            this.byHTL[htl].chkFailure.report(logDist);
            this.byDist[distBucket].chkFailure.report(htl);
        }
    }

    public void log() {
        Logger.normal(this, this.toString());
    }

    private static double fixNaN(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        return d;
    }

    public synchronized String toString() {
        int i;
        StringBuilder s = new StringBuilder();
        s.append("HourlyStats: Report for hour beginning with UTC ");
        s.append(utcDateTime.format(this.beginTime, new StringBuffer(), new FieldPosition(0))).append("\n");
        s.append("HourlyStats: Node uptime (ms):\t").append(this.node.getUptime()).append("\n");
        s.append("HourlyStats: build:\t").append(Version.buildNumber()).append("\n");
        s.append("HourlyStats: CompleteHour: ").append(this.completeHour);
        s.append("\tFinished: ").append(this.finishedReporting).append("\n");
        for (i = this.byHTL.length - 1; i >= 0; --i) {
            s.append("HourlyStats: HTL\t").append(i).append("\t");
            s.append(this.byHTL[i].toString()).append("\n");
        }
        for (i = 0; i < this.byDist.length; ++i) {
            s.append("HourlyStats: logDist\t").append(i).append("\t");
            s.append(this.byDist[i].toString()).append("\n");
        }
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillRemoteRequestHTLsBox(HTMLNode html) {
        HTMLNode table = html.addChild("table");
        HTMLNode row = table.addChild("tr");
        row.addChild("th", "HTL");
        row.addChild("th", "CHKs");
        row.addChild("th", "SSKs");
        row = table.addChild("tr");
        char nbsp = '\u00a0';
        int totalCHKLS = 0;
        int totalCHKRS = 0;
        int totalCHKT = 0;
        int totalSSKLS = 0;
        int totalSSKRS = 0;
        int totalSSKT = 0;
        HourlyStatsRecord hourlyStatsRecord = this;
        synchronized (hourlyStatsRecord) {
            for (int htl = this.byHTL.length - 1; htl >= 0; --htl) {
                row = table.addChild("tr");
                row.addChild("td", Integer.toString(htl));
                StatsLine line = this.byHTL[htl];
                int chkLS = (int)line.chkLocalSuccess.countReports();
                int chkRS = (int)line.chkRemoteSuccess.countReports();
                int chkF = (int)line.chkFailure.countReports();
                int chkT = chkLS + chkRS + chkF;
                int sskLS = (int)line.sskLocalSuccess.countReports();
                int sskRS = (int)line.sskRemoteSuccess.countReports();
                int sskF = (int)line.sskFailure.countReports();
                int sskT = sskLS + sskRS + sskF;
                double locdiffCHK = line.locDiffCHK.currentValue();
                locdiffCHK = Math.pow(2.0, locdiffCHK);
                double locdiffSSK = line.locDiffSSK.currentValue();
                locdiffSSK = Math.pow(2.0, locdiffSSK);
                double chkRate = 0.0;
                double sskRate = 0.0;
                if (chkT > 0) {
                    chkRate = (double)(chkLS + chkRS) / (double)chkT;
                }
                if (sskT > 0) {
                    sskRate = (double)(sskLS + sskRS) / (double)sskT;
                }
                row.addChild("td", fix3p3pct.format(chkRate) + nbsp + "(" + chkLS + "," + chkRS + "," + chkT + ")" + nbsp + "(" + fix4p.format(locdiffCHK) + ")");
                row.addChild("td", fix3p3pct.format(sskRate) + nbsp + "(" + sskLS + "," + sskRS + "," + sskT + ")" + nbsp + "(" + fix4p.format(locdiffSSK) + ")");
                totalCHKLS += chkLS;
                totalCHKRS += chkRS;
                totalCHKT += chkT;
                totalSSKLS += sskLS;
                totalSSKRS += sskRS;
                totalSSKT += sskT;
            }
            double totalCHKRate = 0.0;
            double totalSSKRate = 0.0;
            if (totalCHKT > 0) {
                totalCHKRate = (double)(totalCHKLS + totalCHKRS) / (double)totalCHKT;
            }
            if (totalSSKT > 0) {
                totalSSKRate = (double)(totalSSKLS + totalSSKRS) / (double)totalSSKT;
            }
            row = table.addChild("tr");
            row.addChild("td", "Total");
            row.addChild("td", fix3p3pct.format(totalCHKRate) + nbsp + "(" + totalCHKLS + "," + totalCHKRS + "," + totalCHKT + ")");
            row.addChild("td", fix3p3pct.format(totalSSKRate) + nbsp + "(" + totalSSKLS + "," + totalSSKRS + "," + totalSSKT + ")");
        }
    }

    static {
        utcDateTime.setTimeZone(TimeZone.getTimeZone("UTC"));
        fix3p3pct = new DecimalFormat("##0.000%");
        fix4p = new DecimalFormat("#.0000");
    }

    private class StatsLine {
        TrivialRunningAverage chkLocalSuccess = new TrivialRunningAverage();
        TrivialRunningAverage chkRemoteSuccess = new TrivialRunningAverage();
        TrivialRunningAverage chkFailure = new TrivialRunningAverage();
        TrivialRunningAverage sskLocalSuccess = new TrivialRunningAverage();
        TrivialRunningAverage sskRemoteSuccess = new TrivialRunningAverage();
        TrivialRunningAverage sskFailure = new TrivialRunningAverage();
        TrivialRunningAverage locDiffCHK = new TrivialRunningAverage();
        TrivialRunningAverage locDiffSSK = new TrivialRunningAverage();

        StatsLine() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.chkLocalSuccess.countReports()).append("\t");
            sb.append(this.chkRemoteSuccess.countReports()).append("\t");
            sb.append(this.chkFailure.countReports()).append("\t");
            sb.append(this.sskLocalSuccess.countReports()).append("\t");
            sb.append(this.sskRemoteSuccess.countReports()).append("\t");
            sb.append(this.sskFailure.countReports()).append("\t");
            sb.append(fix4p.format(HourlyStatsRecord.fixNaN(this.chkLocalSuccess.currentValue()))).append("\t");
            sb.append(fix4p.format(HourlyStatsRecord.fixNaN(this.chkRemoteSuccess.currentValue()))).append("\t");
            sb.append(fix4p.format(HourlyStatsRecord.fixNaN(this.chkFailure.currentValue()))).append("\t");
            sb.append(fix4p.format(HourlyStatsRecord.fixNaN(this.sskLocalSuccess.currentValue()))).append("\t");
            sb.append(fix4p.format(HourlyStatsRecord.fixNaN(this.sskRemoteSuccess.currentValue()))).append("\t");
            sb.append(fix4p.format(HourlyStatsRecord.fixNaN(this.sskFailure.currentValue()))).append("\t");
            return sb.toString();
        }
    }
}

