/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.PeerTooOldException;
import freenet.node.SeedServerPeerNode;
import freenet.support.SimpleFieldSet;

public class SeedServerTestPeerNode
extends SeedServerPeerNode {
    public SeedServerTestPeerNode(SimpleFieldSet fs, Node node2, NodeCrypto crypto, boolean fromLocal) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException, PeerTooOldException {
        super(fs, node2, crypto, fromLocal);
    }

    @Override
    public SimpleFieldSet exportFieldSet() {
        SimpleFieldSet sfs = super.exportFieldSet();
        sfs.putOverwrite("opennet", "true");
        return sfs;
    }

    @Override
    public boolean shouldDisconnectAndRemoveNow() {
        return false;
    }

    @Override
    protected void sendInitialMessages() {
    }

    @Override
    public void onRemove() {
        long lastReceivedDataPacketTime = this.lastReceivedDataPacketTime();
        if (lastReceivedDataPacketTime <= 0L && this.timeLastConnectionCompleted() > 0L) {
            System.err.println(this.getIdentityString() + " : REMOVED: TIMEOUT: NO PACKETS RECEIVED AFTER SUCCESSFUL CONNECTION SETUP");
        } else if (this.timeLastConnectionCompleted() <= 0L) {
            System.err.println(this.getIdentityString() + " : REMOVED: NEVER CONNECTED");
        } else {
            System.err.println(this.getIdentityString() + " : REMOVED: UNKNOWN CAUSE");
        }
        super.onRemove();
    }

    public FATE getFate() {
        long lastReceivedDataPacketTime = this.lastReceivedDataPacketTime();
        if (this.isConnected()) {
            if (lastReceivedDataPacketTime <= 0L) {
                return FATE.CONNECTED_NO_PACKETS_RECEIVED;
            }
            if (this.isUnroutableOlderVersion()) {
                return FATE.CONNECTED_TOO_OLD;
            }
            return FATE.CONNECTED_SUCCESS;
        }
        long lastConnectionTime = this.timeLastConnectionCompleted();
        if (lastConnectionTime <= 0L) {
            return FATE.NEVER_CONNECTED;
        }
        if (lastReceivedDataPacketTime <= 0L) {
            return FATE.CONNECTED_TIMEOUT_NO_PACKETS_RECEIVED;
        }
        return FATE.CONNECTED_DISCONNECTED_UNKNOWN;
    }

    public static enum FATE {
        NEVER_CONNECTED,
        CONNECTED_NO_PACKETS_RECEIVED,
        CONNECTED_TOO_OLD,
        CONNECTED_SUCCESS,
        CONNECTED_TIMEOUT_NO_PACKETS_RECEIVED,
        CONNECTED_DISCONNECTED_UNKNOWN;

    }
}

