/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.io.WritableToDataOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;

public class BitArray
implements WritableToDataOutputStream {
    private int size;
    private final BitSet bits;

    public BitArray(byte[] data) {
        this.bits = BitSet.valueOf(data);
        this.size = data.length * 8;
    }

    public BitArray copy() {
        return new BitArray(this);
    }

    public BitArray(DataInput dis) throws IOException {
        this(dis, Integer.MAX_VALUE);
    }

    public BitArray(DataInput dis, int maxSize) throws IOException {
        this.size = dis.readInt();
        if (this.size <= 0 || this.size > maxSize) {
            throw new IOException("Unacceptable bitarray size: " + this.size);
        }
        byte[] inputBits = new byte[this.getByteSize()];
        dis.readFully(inputBits);
        this.bits = BitSet.valueOf(inputBits);
        this.trimToSize();
    }

    public BitArray(int size) {
        this.size = size;
        this.bits = new BitSet(size);
    }

    public BitArray(BitArray src) {
        this.size = src.size;
        this.bits = (BitSet)src.bits.clone();
    }

    public void setBit(int pos, boolean f) {
        this.checkPos(pos);
        this.bits.set(pos, f);
    }

    public boolean bitAt(int pos) {
        this.checkPos(pos);
        return this.bits.get(pos);
    }

    static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.size);
        for (int x = 0; x < this.size; ++x) {
            if (this.bitAt(x)) {
                sb.append('1');
                continue;
            }
            sb.append('0');
        }
        return sb.toString();
    }

    @Override
    public void writeToDataOutputStream(DataOutputStream dos) throws IOException {
        dos.writeInt(this.size);
        byte[] outputBits = this.bits.toByteArray();
        if (outputBits.length != this.getByteSize()) {
            outputBits = Arrays.copyOf(outputBits, this.getByteSize());
        }
        dos.write(outputBits);
    }

    public static int serializedLength(int size) {
        return BitArray.toByteSize(size) + 4;
    }

    public int getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitArray)) {
            return false;
        }
        BitArray ba = (BitArray)o;
        if (ba.getSize() != this.getSize()) {
            return false;
        }
        return this.bits.equals(ba.bits);
    }

    public int hashCode() {
        return this.bits.hashCode() ^ this.size;
    }

    public void setAllOnes() {
        this.bits.set(0, this.size);
    }

    public int firstOne(int start) {
        return this.bits.nextSetBit(start);
    }

    public int firstOne() {
        return this.firstOne(0);
    }

    public int firstZero(int start) {
        int result = this.bits.nextClearBit(start);
        if (result >= this.size) {
            return -1;
        }
        return result;
    }

    public void setSize(int size) {
        this.size = size;
        this.trimToSize();
    }

    public int lastOne(int start) {
        return this.bits.previousSetBit(start);
    }

    private void trimToSize() {
        this.bits.clear(this.size, Integer.MAX_VALUE);
    }

    private int getByteSize() {
        return BitArray.toByteSize(this.size);
    }

    private static int toByteSize(int bitSize) {
        return (bitSize + 7) / 8;
    }

    private void checkPos(int pos) {
        if (pos > this.size || pos < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }
}

