/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.support.Logger;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.api.LockableRandomAccessBufferFactory;
import freenet.support.io.DiskSpaceChecker;
import freenet.support.io.FileRandomAccessBufferFactory;
import freenet.support.io.FileUtil;
import freenet.support.io.InsufficientDiskSpaceException;
import freenet.support.io.PooledFileRandomAccessBuffer;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DiskSpaceCheckingRandomAccessBufferFactory
implements LockableRandomAccessBufferFactory,
DiskSpaceChecker,
FileRandomAccessBufferFactory {
    private final LockableRandomAccessBufferFactory underlying;
    private final File dir;
    private volatile long minDiskSpace;
    private static final Lock lock = new ReentrantLock(true);

    public DiskSpaceCheckingRandomAccessBufferFactory(LockableRandomAccessBufferFactory underlying, File dir, long minDiskSpace) {
        this.underlying = underlying;
        this.dir = dir;
        this.minDiskSpace = minDiskSpace;
    }

    public void setMinDiskSpace(long min) {
        if (min < 0L) {
            throw new IllegalArgumentException();
        }
        this.minDiskSpace = min;
    }

    @Override
    public LockableRandomAccessBuffer makeRAF(long size) throws IOException {
        lock.lock();
        try {
            if (this.dir.getUsableSpace() > size + this.minDiskSpace) {
                LockableRandomAccessBuffer lockableRandomAccessBuffer = this.underlying.makeRAF(size);
                return lockableRandomAccessBuffer;
            }
            throw new InsufficientDiskSpaceException();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public synchronized LockableRandomAccessBuffer makeRAF(byte[] initialContents, int offset, int size, boolean readOnly) throws IOException {
        lock.lock();
        try {
            if (this.dir.getUsableSpace() > (long)size + this.minDiskSpace) {
                LockableRandomAccessBuffer lockableRandomAccessBuffer = this.underlying.makeRAF(initialContents, offset, size, readOnly);
                return lockableRandomAccessBuffer;
            }
            throw new InsufficientDiskSpaceException();
        }
        finally {
            lock.unlock();
        }
    }

    public String toString() {
        return super.toString() + ":" + this.underlying.toString();
    }

    @Override
    public PooledFileRandomAccessBuffer createNewRAF(File file, long size, Random random) throws IOException {
        lock.lock();
        PooledFileRandomAccessBuffer ret = null;
        try {
            if (!file.exists()) {
                throw new IOException("File does not exist");
            }
            if (file.length() != 0L) {
                throw new IOException("File is wrong length");
            }
            if (this.dir.getUsableSpace() > size + this.minDiskSpace) {
                PooledFileRandomAccessBuffer pooledFileRandomAccessBuffer = ret = new PooledFileRandomAccessBuffer(file, false, size, random, -1L, true);
                return pooledFileRandomAccessBuffer;
            }
            throw new InsufficientDiskSpaceException();
        }
        finally {
            if (ret == null) {
                file.delete();
            }
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkDiskSpace(File file, int toWrite, int bufferSize) {
        if (!FileUtil.isParent(this.dir, file)) {
            Logger.error(this, "Not checking disk space because " + file + " is not child of " + this.dir);
            return true;
        }
        lock.lock();
        try {
            if (this.dir.getUsableSpace() - (long)(toWrite + bufferSize) < this.minDiskSpace) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }
}

