/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class HeaderStreams {
    private HeaderStreams() {
    }

    public static InputStream augInput(final byte[] hd, InputStream s) throws IOException {
        return new FilterInputStream(s){
            private int i;
            {
                super(x0);
                this.i = 0;
            }

            @Override
            public int available() throws IOException {
                return hd.length - this.i + this.in.available();
            }

            @Override
            public int read() throws IOException {
                return this.i < hd.length ? hd[this.i++] & 0xFF : this.in.read();
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                int prev = this.i;
                while (this.i < hd.length && len > 0) {
                    buf[off] = hd[this.i];
                    ++this.i;
                    --len;
                    ++off;
                }
                return this.i - prev + this.in.read(buf, off, len);
            }

            @Override
            public long skip(long len) throws IOException {
                int prev = this.i;
                while (this.i < hd.length && len > 0L) {
                    ++this.i;
                    --len;
                }
                return (long)(this.i - prev) + this.in.skip(len);
            }

            @Override
            public boolean markSupported() {
                return false;
            }

            @Override
            public void mark(int limit) {
            }

            @Override
            public void reset() throws IOException {
                throw new IOException("mark/reset not supported");
            }
        };
    }

    public static OutputStream dimOutput(final byte[] hd, OutputStream s) {
        return new FilterOutputStream(s){
            private int i;
            {
                super(x0);
                this.i = 0;
            }

            @Override
            public void write(int b) throws IOException {
                if (this.i < hd.length) {
                    if ((byte)b != hd[this.i]) {
                        throw new IOException("byte " + this.i + ": expected '" + hd[this.i] + "'; got '" + b + "'.");
                    }
                    ++this.i;
                } else {
                    this.out.write(b);
                }
            }

            @Override
            public void write(byte[] buf, int off, int len) throws IOException {
                while (this.i < hd.length && len > 0) {
                    if (buf[off] != hd[this.i]) {
                        throw new IOException("byte " + this.i + ": expected '" + hd[this.i] + "'; got '" + buf[off] + "'.");
                    }
                    ++this.i;
                    --len;
                    ++off;
                }
                this.out.write(buf, off, len);
            }
        };
    }
}

