/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.async.ClientContext;
import freenet.support.api.Bucket;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.NullInputStream;
import freenet.support.io.NullOutputStream;
import freenet.support.io.NullRandomAccessBuffer;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class NullBucket
implements Bucket,
Serializable,
RandomAccessBucket {
    private static final long serialVersionUID = 1L;
    public static final OutputStream nullOut = new NullOutputStream();
    public static final InputStream nullIn = new NullInputStream();
    public final long length;

    public NullBucket() {
        this(0L);
    }

    public NullBucket(long length) {
        this.length = length;
    }

    @Override
    public OutputStream getOutputStream() {
        return nullOut;
    }

    @Override
    public OutputStream getOutputStreamUnbuffered() {
        return nullOut;
    }

    @Override
    public InputStream getInputStream() {
        return nullIn;
    }

    @Override
    public InputStream getInputStreamUnbuffered() {
        return nullIn;
    }

    @Override
    public long size() {
        return this.length;
    }

    @Override
    public String getName() {
        return "President George W. NullBucket";
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void setReadOnly() {
    }

    @Override
    public void free() {
    }

    @Override
    public RandomAccessBucket createShadow() {
        return new NullBucket();
    }

    @Override
    public void onResume(ClientContext context) {
    }

    @Override
    public void storeTo(DataOutputStream dos) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public LockableRandomAccessBuffer toRandomAccessBuffer() throws IOException {
        return new NullRandomAccessBuffer(this.length);
    }
}

