/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.math;

import freenet.support.Logger;
import freenet.support.math.RunningAverage;
import java.io.DataOutputStream;

public final class SimpleRunningAverage
implements RunningAverage,
Cloneable {
    private static final long serialVersionUID = -1L;
    final double[] refs;
    int nextSlotPtr = 0;
    int curLen = 0;
    double total = 0.0;
    int totalReports = 0;
    final double initValue;
    private boolean logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);

    @Override
    public final SimpleRunningAverage clone() {
        return new SimpleRunningAverage(this);
    }

    public synchronized void clear() {
        this.nextSlotPtr = 0;
        this.curLen = 0;
        this.totalReports = 0;
        this.total = 0.0;
        for (int i = 0; i < this.refs.length; ++i) {
            this.refs[i] = 0.0;
        }
    }

    public SimpleRunningAverage(int length, double initValue) {
        this.refs = new double[length];
        this.initValue = initValue;
        this.totalReports = 0;
    }

    public SimpleRunningAverage(SimpleRunningAverage a) {
        this.curLen = a.curLen;
        this.initValue = a.initValue;
        this.nextSlotPtr = a.nextSlotPtr;
        this.refs = (double[])a.refs.clone();
        this.total = a.total;
        this.totalReports = a.totalReports;
    }

    @Override
    public synchronized double currentValue() {
        if (this.curLen == 0) {
            return this.initValue;
        }
        return this.total / (double)this.curLen;
    }

    @Override
    public synchronized double valueIfReported(double r) {
        if (this.curLen < this.refs.length) {
            return (this.total + r) / (double)(this.curLen + 1);
        }
        return (this.total + r - this.refs[this.nextSlotPtr]) / (double)this.curLen;
    }

    @Override
    public synchronized void report(double d) {
        ++this.totalReports;
        if (this.logDEBUG) {
            Logger.debug(this, "report(" + d + ") on " + this);
        }
        if (this.curLen < this.refs.length) {
            ++this.curLen;
        } else {
            this.total -= this.popValue();
        }
        this.pushValue(d);
        this.total += d;
    }

    protected synchronized void pushValue(double value) {
        this.refs[this.nextSlotPtr] = value;
        ++this.nextSlotPtr;
        if (this.nextSlotPtr >= this.refs.length) {
            this.nextSlotPtr = 0;
        }
    }

    protected synchronized double popValue() {
        return this.refs[this.nextSlotPtr];
    }

    public synchronized String toString() {
        return super.toString() + ": curLen=" + this.curLen + ", ptr=" + this.nextSlotPtr + ", total=" + this.total + ", average=" + this.total / (double)this.curLen;
    }

    @Override
    public void report(long d) {
        this.report((double)d);
    }

    public void writeDataTo(DataOutputStream out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized long countReports() {
        return this.totalReports;
    }

    public synchronized double minReportForValue(double targetValue) {
        if (this.curLen < this.refs.length) {
            return targetValue * (double)(this.curLen + 1) - this.total;
        }
        return targetValue * (double)this.curLen - (this.total - this.refs[this.nextSlotPtr]);
    }
}

