/*
 * Decompiled with CFR 0.152.
 */
package plugins.UPnP;

import freenet.clients.http.PageNode;
import freenet.pluginmanager.DetectedIP;
import freenet.pluginmanager.ForwardPort;
import freenet.pluginmanager.ForwardPortCallback;
import freenet.pluginmanager.ForwardPortStatus;
import freenet.pluginmanager.FredPlugin;
import freenet.pluginmanager.FredPluginBandwidthIndicator;
import freenet.pluginmanager.FredPluginHTTP;
import freenet.pluginmanager.FredPluginIPDetector;
import freenet.pluginmanager.FredPluginPortForward;
import freenet.pluginmanager.FredPluginRealVersioned;
import freenet.pluginmanager.FredPluginThreadless;
import freenet.pluginmanager.FredPluginVersioned;
import freenet.pluginmanager.PluginHTTPException;
import freenet.pluginmanager.PluginRespirator;
import freenet.support.HTMLEncoder;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.api.HTTPRequest;
import freenet.support.transport.ip.IPUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import plugins.UPnP.Version;
import plugins.UPnP.org.cybergarage.upnp.Action;
import plugins.UPnP.org.cybergarage.upnp.ActionList;
import plugins.UPnP.org.cybergarage.upnp.Argument;
import plugins.UPnP.org.cybergarage.upnp.ArgumentList;
import plugins.UPnP.org.cybergarage.upnp.ControlPoint;
import plugins.UPnP.org.cybergarage.upnp.Device;
import plugins.UPnP.org.cybergarage.upnp.DeviceList;
import plugins.UPnP.org.cybergarage.upnp.Service;
import plugins.UPnP.org.cybergarage.upnp.ServiceList;
import plugins.UPnP.org.cybergarage.upnp.ServiceStateTable;
import plugins.UPnP.org.cybergarage.upnp.StateVariable;
import plugins.UPnP.org.cybergarage.upnp.device.DeviceChangeListener;

public class UPnP
extends ControlPoint
implements FredPluginHTTP,
FredPlugin,
FredPluginThreadless,
FredPluginIPDetector,
FredPluginPortForward,
FredPluginBandwidthIndicator,
FredPluginVersioned,
FredPluginRealVersioned,
DeviceChangeListener {
    private PluginRespirator pr;
    private static final String ROUTER_DEVICE = "urn:schemas-upnp-org:device:InternetGatewayDevice:1";
    private static final String WAN_DEVICE = "urn:schemas-upnp-org:device:WANDevice:1";
    private static final String WANCON_DEVICE = "urn:schemas-upnp-org:device:WANConnectionDevice:1";
    private static final String WAN_IP_CONNECTION = "urn:schemas-upnp-org:service:WANIPConnection:1";
    private static final String WAN_PPP_CONNECTION = "urn:schemas-upnp-org:service:WANPPPConnection:1";
    private Device _router;
    private Service _service;
    private boolean isDisabled = false;
    private final Object lock = new Object();
    private volatile boolean thinksWeAreDoubleNatted = false;
    private Set<ForwardPort> portsToForward;
    private Set<ForwardPort> portsForwarded = new HashSet<ForwardPort>();
    private ForwardPortCallback forwardCallback;

    public UPnP() {
        this.addDeviceChangeListener(this);
    }

    public void runPlugin(PluginRespirator pr) {
        this.pr = pr;
        super.start();
    }

    public void terminate() {
        this.unregisterPortMappings();
        super.stop();
    }

    public DetectedIP[] getAddress() {
        Logger.minor((Object)this, (String)"UPnP.getAddress() is called \\o/");
        if (this.isDisabled) {
            Logger.normal((Object)this, (String)"Plugin has been disabled previously, ignoring request.");
            return null;
        }
        if (!this.isNATPresent()) {
            Logger.normal((Object)this, (String)"No UPnP device found, detection of the external ip address using the plugin has failed");
            return null;
        }
        DetectedIP result = null;
        String natAddress = this.getNATAddress();
        try {
            InetAddress detectedIP = InetAddress.getByName(natAddress);
            short status = 1;
            boolean bl = this.thinksWeAreDoubleNatted = !IPUtil.isValidAddress((InetAddress)detectedIP, (boolean)false);
            if (this.portsForwarded.size() > 1 && !this.thinksWeAreDoubleNatted) {
                status = 2;
            }
            result = new DetectedIP(detectedIP, status);
            Logger.normal((Object)this, (String)("Successful UPnP discovery:" + result));
            System.out.println("Successful UPnP discovery:" + result);
            return new DetectedIP[]{result};
        }
        catch (UnknownHostException e) {
            Logger.error((Object)this, (String)("Caught an UnknownHostException resolving " + natAddress), (Throwable)e);
            System.err.println("UPnP discovery has failed: unable to resolve " + result);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deviceAdded(Device dev) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isDisabled) {
                Logger.normal((Object)this, (String)"Plugin has been disabled previously, ignoring new device.");
                return;
            }
        }
        if (!ROUTER_DEVICE.equals(dev.getDeviceType()) || !dev.isRootDevice()) {
            return;
        }
        if (this.isNATPresent()) {
            Logger.error((Object)this, (String)"We got a second IGD on the network! the plugin doesn't handle that: let's disable it.");
            System.err.println("The UPnP plugin has found more than one IGD on the network, as a result it will be disabled");
            this.isDisabled = true;
            object = this.lock;
            synchronized (object) {
                this._router = null;
                this._service = null;
            }
            this.stop();
            return;
        }
        Logger.normal((Object)this, (String)("UPnP IGD found: " + dev.getFriendlyName()));
        System.out.println("UPnP IGD found: " + dev.getFriendlyName());
        object = this.lock;
        synchronized (object) {
            this._router = dev;
        }
        this.discoverService();
        this.stop();
        object = this.lock;
        synchronized (object) {
            if (this._service == null) {
                Logger.error((Object)this, (String)"The IGD device we got isn't suiting our needs, let's disable the plugin");
                System.err.println("The IGD device we got isn't suiting our needs, let's disable the plugin");
                this.isDisabled = true;
                this._router = null;
                return;
            }
        }
        this.registerPortMappings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPortMappings() {
        HashSet<ForwardPort> ports = new HashSet<ForwardPort>();
        Object object = this.lock;
        synchronized (object) {
            if (this.portsToForward != null) {
                ports.addAll(this.portsToForward);
            }
        }
        if (ports.isEmpty()) {
            return;
        }
        this.registerPorts(ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverService() {
        Object object = this.lock;
        synchronized (object) {
            for (Device current : this._router.getDeviceList()) {
                if (!current.getDeviceType().equals(WAN_DEVICE)) continue;
                DeviceList l = current.getDeviceList();
                for (int i = 0; i < current.getDeviceList().size(); ++i) {
                    Device current2 = l.getDevice(i);
                    if (!current2.getDeviceType().equals(WANCON_DEVICE)) continue;
                    this._service = current2.getService(WAN_PPP_CONNECTION);
                    if (this._service == null) {
                        Logger.normal((Object)this, (String)(this._router.getFriendlyName() + " doesn't seems to be using PPP; we won't be able to extract" + " bandwidth-related informations out of it."));
                        this._service = current2.getService(WAN_IP_CONNECTION);
                        if (this._service == null) {
                            Logger.error((Object)this, (String)(this._router.getFriendlyName() + " doesn't export WAN_IP_CONNECTION either: we won't" + " be able to use it!"));
                        }
                    }
                    return;
                }
            }
        }
    }

    public boolean tryAddMapping(String protocol, int port, String description, ForwardPort fp) {
        Logger.normal((Object)this, (String)("Registering a port mapping for " + port + "/" + protocol));
        System.err.println("UPnP: Registering a port mapping for " + port + "/" + protocol);
        int nbOfTries = 0;
        boolean isPortForwarded = false;
        while (nbOfTries++ < 5 && !(isPortForwarded = this.addMapping(protocol, port, "Freenet 0.7 " + description, fp))) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Logger.normal((Object)this, (String)((isPortForwarded ? "Mapping is successful!" : "Mapping has failed!") + " (" + nbOfTries + " tries)"));
        System.err.println("UPnP: " + (isPortForwarded ? "Mapping is successful!" : "Mapping has failed!") + " (" + nbOfTries + " tries)");
        return isPortForwarded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPortMappings() {
        HashSet<ForwardPort> ports = new HashSet<ForwardPort>();
        Object object = this.lock;
        synchronized (object) {
            ports.addAll(this.portsForwarded);
        }
        this.unregisterPorts(ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deviceRemoved(Device dev) {
        Object object = this.lock;
        synchronized (object) {
            if (this._router == null) {
                return;
            }
            if (this._router.equals(dev)) {
                this._router = null;
                this._service = null;
            }
        }
    }

    public boolean isNATPresent() {
        return this._router != null && this._service != null;
    }

    public String getNATAddress() {
        if (!this.isNATPresent()) {
            return null;
        }
        Action getIP = this._service.getAction("GetExternalIPAddress");
        if (getIP == null || !getIP.postControlAction()) {
            return null;
        }
        return getIP.getOutputArgumentList().getArgument("NewExternalIPAddress").getValue();
    }

    public int getUpstramMaxBitRate() {
        if (!this.isNATPresent() || this.thinksWeAreDoubleNatted) {
            return -1;
        }
        Action getIP = this._service.getAction("GetLinkLayerMaxBitRates");
        if (getIP != null && !getIP.postControlAction()) {
            try {
                return Integer.valueOf(getIP.getOutputArgumentList().getArgument("NewUpstreamMaxBitRate").getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((getIP = this._service.getAction("GetCommonLinkProperties")) != null && !getIP.postControlAction()) {
            try {
                return Integer.valueOf(getIP.getOutputArgumentList().getArgument("NewLayer1UpstreamMaxBitRate").getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.getUpstreamMaxBitRate(this._router);
    }

    public int getDownstreamMaxBitRate() {
        if (!this.isNATPresent() || this.thinksWeAreDoubleNatted) {
            return -1;
        }
        Action getIP = this._service.getAction("GetLinkLayerMaxBitRates");
        if (getIP != null && !getIP.postControlAction()) {
            try {
                return Integer.valueOf(getIP.getOutputArgumentList().getArgument("NewDownstreamMaxBitRate").getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((getIP = this._service.getAction("GetCommonLinkProperties")) != null && !getIP.postControlAction()) {
            try {
                return Integer.valueOf(getIP.getOutputArgumentList().getArgument("NewLayer1DownstreamMaxBitRate").getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.getDownstreamMaxBitRate(this._router);
    }

    private int getDownstreamMaxBitRate(Device dev) {
        ServiceList sl = dev.getServiceList();
        for (int i = 0; i < sl.size(); ++i) {
            Action getIP;
            Service serv = sl.getService(i);
            if (serv == null) continue;
            if ("urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1".equals(serv.getServiceType()) && (getIP = serv.getAction("GetCommonLinkProperties")) != null && getIP.postControlAction()) {
                try {
                    return Integer.valueOf(getIP.getOutputArgumentList().getArgument("NewLayer1DownstreamMaxBitRate").getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!WAN_PPP_CONNECTION.equals(serv.getServiceType()) || (getIP = serv.getAction("GetLinkLayerMaxBitRates")) == null || !getIP.postControlAction()) continue;
            try {
                return Integer.valueOf(getIP.getOutputArgumentList().getArgument("NewDownstreamMaxBitRate").getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        DeviceList dl = dev.getDeviceList();
        for (int j = 0; j < dl.size(); ++j) {
            int x;
            Device subDev = dl.getDevice(j);
            if (subDev == null || (x = this.getDownstreamMaxBitRate(subDev)) == -1) continue;
            return x;
        }
        return -1;
    }

    private int getUpstreamMaxBitRate(Device dev) {
        ServiceList sl = dev.getServiceList();
        for (int i = 0; i < sl.size(); ++i) {
            Action getIP;
            Service serv = sl.getService(i);
            if (serv == null) continue;
            if ("urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1".equals(serv.getServiceType()) && (getIP = serv.getAction("GetCommonLinkProperties")) != null && getIP.postControlAction()) {
                try {
                    return Integer.valueOf(getIP.getOutputArgumentList().getArgument("NewLayer1UpstreamMaxBitRate").getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!WAN_PPP_CONNECTION.equals(serv.getServiceType()) || (getIP = serv.getAction("GetLinkLayerMaxBitRates")) == null || !getIP.postControlAction()) continue;
            try {
                return Integer.valueOf(getIP.getOutputArgumentList().getArgument("NewUpstreamMaxBitRate").getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        DeviceList dl = dev.getDeviceList();
        for (int j = 0; j < dl.size(); ++j) {
            int x;
            Device subDev = dl.getDevice(j);
            if (subDev == null || (x = this.getUpstreamMaxBitRate(subDev)) == -1) continue;
            return x;
        }
        return -1;
    }

    private void listStateTable(Service serv, StringBuilder sb) {
        ServiceStateTable table = serv.getServiceStateTable();
        sb.append("<div><small>");
        for (int i = 0; i < table.size(); ++i) {
            StateVariable current = table.getStateVariable(i);
            sb.append(String.format("%s: %s<br>", HTMLEncoder.encode((String)current.getName()), HTMLEncoder.encode((String)current.getValue())));
        }
        sb.append("</small></div>");
    }

    private void listActionsArguments(Action action, StringBuilder sb) {
        ArgumentList ar = action.getArgumentList();
        for (int i = 0; i < ar.size(); ++i) {
            Argument argument = ar.getArgument(i);
            if (argument == null) continue;
            sb.append(String.format("<div><small>argument (%d): %s</small></div>", i, HTMLEncoder.encode((String)argument.getName())));
        }
    }

    private void listActions(Service service, StringBuilder sb) {
        ActionList al = service.getActionList();
        for (int i = 0; i < al.size(); ++i) {
            Action action = al.getAction(i);
            if (action == null) continue;
            sb.append(String.format("<div>action (%d): %s", i, HTMLEncoder.encode((String)action.getName())));
            this.listActionsArguments(action, sb);
            sb.append("</div>");
        }
    }

    private String toString(String action, String Argument2, Service serv) {
        Action getIP = serv.getAction(action);
        if (getIP == null || !getIP.postControlAction()) {
            return null;
        }
        Argument ret = getIP.getOutputArgumentList().getArgument(Argument2);
        return ret.getValue();
    }

    private void listSubServices(Device dev, StringBuilder sb) {
        ServiceList sl = dev.getServiceList();
        for (int i = 0; i < sl.size(); ++i) {
            Service serv = sl.getService(i);
            if (serv == null) continue;
            sb.append(String.format("<div>service (%d): %s<br>", i, HTMLEncoder.encode((String)serv.getServiceType())));
            if ("urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1".equals(serv.getServiceType())) {
                sb.append("WANCommonInterfaceConfig");
                sb.append(String.format(" status: %s", HTMLEncoder.encode((String)this.toString("GetCommonLinkProperties", "NewPhysicalLinkStatus", serv))));
                sb.append(String.format(" type: %s", HTMLEncoder.encode((String)this.toString("GetCommonLinkProperties", "NewWANAccessType", serv))));
                sb.append(String.format(" upstream: %s", HTMLEncoder.encode((String)this.toString("GetCommonLinkProperties", "NewLayer1UpstreamMaxBitRate", serv))));
                sb.append(String.format(" downstream: %s<br>", HTMLEncoder.encode((String)this.toString("GetCommonLinkProperties", "NewLayer1DownstreamMaxBitRate", serv))));
            } else if (WAN_PPP_CONNECTION.equals(serv.getServiceType())) {
                sb.append("WANPPPConnection");
                sb.append(String.format(" status: %s", HTMLEncoder.encode((String)this.toString("GetStatusInfo", "NewConnectionStatus", serv))));
                sb.append(String.format(" type: %s", HTMLEncoder.encode((String)this.toString("GetConnectionTypeInfo", "NewConnectionType", serv))));
                sb.append(String.format(" upstream: %s", HTMLEncoder.encode((String)this.toString("GetLinkLayerMaxBitRates", "NewUpstreamMaxBitRate", serv))));
                sb.append(String.format(" downstream: %s<br>", HTMLEncoder.encode((String)this.toString("GetLinkLayerMaxBitRates", "NewDownstreamMaxBitRate", serv))));
                sb.append(String.format(" external IP: %s<br>", HTMLEncoder.encode((String)this.toString("GetExternalIPAddress", "NewExternalIPAddress", serv))));
            } else if ("urn:schemas-upnp-org:service:Layer3Forwarding:1".equals(serv.getServiceType())) {
                sb.append("Layer3Forwarding");
                sb.append(String.format("DefaultConnectionService: %s", HTMLEncoder.encode((String)this.toString("GetDefaultConnectionService", "NewDefaultConnectionService", serv))));
            } else if (WAN_IP_CONNECTION.equals(serv.getServiceType())) {
                sb.append("WANIPConnection");
                sb.append(String.format(" status: %s", HTMLEncoder.encode((String)this.toString("GetStatusInfo", "NewConnectionStatus", serv))));
                sb.append(String.format(" type: %s", HTMLEncoder.encode((String)this.toString("GetConnectionTypeInfo", "NewConnectionType", serv))));
                sb.append(String.format(" external IP: %s<br>", HTMLEncoder.encode((String)this.toString("GetExternalIPAddress", "NewExternalIPAddress", serv))));
            } else if ("urn:schemas-upnp-org:service:WANEthernetLinkConfig:1".equals(serv.getServiceType())) {
                sb.append("WANEthernetLinkConfig");
                sb.append(String.format(" status: %s<br>", HTMLEncoder.encode((String)this.toString("GetEthernetLinkStatus", "NewEthernetLinkStatus", serv))));
            } else {
                sb.append(String.format("~~~~~~~ %s", HTMLEncoder.encode((String)serv.getServiceType())));
            }
            this.listActions(serv, sb);
            this.listStateTable(serv, sb);
            sb.append("</div>");
        }
    }

    private void listSubDev(String prefix, Device dev, StringBuilder sb) {
        sb.append(String.format("<div><p>Device: %s - %s<br>", HTMLEncoder.encode((String)dev.getFriendlyName()), HTMLEncoder.encode((String)dev.getDeviceType())));
        this.listSubServices(dev, sb);
        DeviceList dl = dev.getDeviceList();
        for (int j = 0; j < dl.size(); ++j) {
            Device subDev = dl.getDevice(j);
            if (subDev == null) continue;
            sb.append("<div>");
            this.listSubDev(dev.getFriendlyName(), subDev, sb);
            sb.append("</div></div>");
        }
        sb.append("</p></div>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String handleHTTPGet(HTTPRequest request) throws PluginHTTPException {
        if (request.isParameterSet("getDeviceCapabilities")) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html><head><title>UPnP report</title></head><body>");
            this.listSubDev("WANDevice", this._router, sb);
            sb.append("</body></html>");
            return sb.toString();
        }
        PageNode page = this.pr.getPageMaker().getPageNode("UPnP plugin configuration page", false, null);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        if (this.isDisabled) {
            HTMLNode disabledInfobox = contentNode.addChild("div", "class", "infobox infobox-error");
            HTMLNode disabledInfoboxHeader = disabledInfobox.addChild("div", "class", "infobox-header");
            HTMLNode disabledInfoboxContent = disabledInfobox.addChild("div", "class", "infobox-content");
            disabledInfoboxHeader.addChild("#", "UPnP plugin report");
            disabledInfoboxContent.addChild("#", "The plugin has been disabled; Do you have more than one UPnP IGD on your LAN ?");
            return pageNode.generate();
        }
        if (!this.isNATPresent()) {
            HTMLNode notFoundInfobox = contentNode.addChild("div", "class", "infobox infobox-warning");
            HTMLNode notFoundInfoboxHeader = notFoundInfobox.addChild("div", "class", "infobox-header");
            HTMLNode notFoundInfoboxContent = notFoundInfobox.addChild("div", "class", "infobox-content");
            notFoundInfoboxHeader.addChild("#", "UPnP plugin report");
            notFoundInfoboxContent.addChild("#", "The plugin hasn't found any UPnP aware, compatible device on your LAN.");
            return pageNode.generate();
        }
        HTMLNode foundInfobox = contentNode.addChild("div", "class", "infobox infobox-normal");
        HTMLNode foundInfoboxHeader = foundInfobox.addChild("div", "class", "infobox-header");
        HTMLNode foundInfoboxContent = foundInfobox.addChild("div", "class", "infobox-content");
        foundInfoboxHeader.addChild("#", "UPnP plugin report");
        foundInfoboxContent.addChild("p", "The following device has been found: ").addChild("a", "href", "?getDeviceCapabilities").addChild("#", this._router.getFriendlyName());
        foundInfoboxContent.addChild("p", "Our current external ip address is: " + this.getNATAddress());
        int downstreamMaxBitRate = this.getDownstreamMaxBitRate();
        int upstreamMaxBitRate = this.getUpstramMaxBitRate();
        if (downstreamMaxBitRate > 0) {
            foundInfoboxContent.addChild("p", "Our reported max downstream bit rate is: " + this.getDownstreamMaxBitRate() + " bits/sec");
        }
        if (upstreamMaxBitRate > 0) {
            foundInfoboxContent.addChild("p", "Our reported max upstream bit rate is: " + this.getUpstramMaxBitRate() + " bits/sec");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.portsToForward != null) {
                for (ForwardPort port : this.portsToForward) {
                    if (this.portsForwarded.contains(port)) {
                        foundInfoboxContent.addChild("p", "The " + port.name + " port " + port.portNumber + " / " + port.protocol + " has been forwarded successfully.");
                        continue;
                    }
                    foundInfoboxContent.addChild("p", "The " + port.name + " port " + port.portNumber + " / " + port.protocol + " has not been forwarded.");
                }
            }
        }
        return pageNode.generate();
    }

    public String handleHTTPPost(HTTPRequest request) throws PluginHTTPException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addMapping(String protocol, int port, String description, ForwardPort fp) {
        if (this.isDisabled || !this.isNATPresent() || this._router == null) {
            return false;
        }
        this.removeMapping(protocol, port, fp, true);
        Action add = this._service.getAction("AddPortMapping");
        if (add == null) {
            Logger.error((Object)this, (String)"Couldn't find AddPortMapping action!");
            return false;
        }
        add.setArgumentValue("NewRemoteHost", "");
        add.setArgumentValue("NewExternalPort", port);
        add.setArgumentValue("NewInternalClient", this._router.getInterfaceAddress());
        add.setArgumentValue("NewInternalPort", port);
        add.setArgumentValue("NewProtocol", protocol);
        add.setArgumentValue("NewPortMappingDescription", description);
        add.setArgumentValue("NewEnabled", "1");
        add.setArgumentValue("NewLeaseDuration", 0);
        if (add.postControlAction()) {
            Object object = this.lock;
            synchronized (object) {
                this.portsForwarded.add(fp);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMapping(String protocol, int port, ForwardPort fp, boolean noLog) {
        if (this.isDisabled || !this.isNATPresent()) {
            return false;
        }
        Action remove = this._service.getAction("DeletePortMapping");
        if (remove == null) {
            Logger.error((Object)this, (String)"Couldn't find DeletePortMapping action!");
            return false;
        }
        remove.setArgumentValue("NewExternalPort", port);
        remove.setArgumentValue("NewProtocol", protocol);
        boolean retval = remove.postControlAction();
        Object object = this.lock;
        synchronized (object) {
            this.portsForwarded.remove(fp);
        }
        if (!noLog) {
            System.err.println("UPnP: Removed mapping for " + fp.name + " " + port + " / " + protocol);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChangePublicPorts(Set<ForwardPort> ports, ForwardPortCallback cb) {
        Set<ForwardPort> portsToDumpNow = null;
        Set<ForwardPort> portsToForwardNow = null;
        System.err.println("UPnP Forwarding " + ports.size() + " ports...");
        Object object = this.lock;
        synchronized (object) {
            if (this.forwardCallback != null && this.forwardCallback != cb && cb != null) {
                Logger.error((Object)this, (String)("ForwardPortCallback changed from " + this.forwardCallback + " to " + cb + " - using new value, but this is very strange!"));
            }
            this.forwardCallback = cb;
            if (this.portsToForward == null || this.portsToForward.isEmpty()) {
                this.portsToForward = ports;
                portsToForwardNow = ports;
                portsToDumpNow = null;
            } else if (ports == null || ports.isEmpty()) {
                portsToDumpNow = this.portsToForward;
                this.portsToForward = ports;
                portsToForwardNow = null;
            } else {
                for (ForwardPort port : ports) {
                    if (this.portsToForward.contains(port)) continue;
                    if (portsToForwardNow == null) {
                        portsToForwardNow = new HashSet<ForwardPort>();
                    }
                    portsToForwardNow.add(port);
                }
                for (ForwardPort port : this.portsToForward) {
                    if (ports.contains(port)) continue;
                    if (portsToDumpNow == null) {
                        portsToDumpNow = new HashSet<ForwardPort>();
                    }
                    portsToDumpNow.add(port);
                }
                this.portsToForward = ports;
            }
            if (this._router == null) {
                return;
            }
        }
        if (portsToDumpNow != null) {
            this.unregisterPorts(portsToDumpNow);
        }
        if (portsToForwardNow != null) {
            this.registerPorts(portsToForwardNow);
        }
    }

    private void registerPorts(Set<ForwardPort> portsToForwardNow) {
        for (ForwardPort port : portsToForwardNow) {
            HashMap<ForwardPort, ForwardPortStatus> map;
            String proto;
            if (port.protocol == 17) {
                proto = "UDP";
            } else if (port.protocol == 6) {
                proto = "TCP";
            } else {
                map = new HashMap<ForwardPort, ForwardPortStatus>();
                map.put(port, new ForwardPortStatus(-2, "Protocol not supported", port.portNumber));
                this.forwardCallback.portForwardStatus(map);
                continue;
            }
            if (this.tryAddMapping(proto, port.portNumber, port.name, port)) {
                map = new HashMap();
                map.put(port, new ForwardPortStatus(1, "Port apparently forwarded by UPnP", port.portNumber));
                this.forwardCallback.portForwardStatus(map);
                continue;
            }
            map = new HashMap();
            map.put(port, new ForwardPortStatus(-1, "UPnP port forwarding apparently failed", port.portNumber));
            this.forwardCallback.portForwardStatus(map);
        }
    }

    private void unregisterPorts(Set<ForwardPort> portsToForwardNow) {
        for (ForwardPort port : portsToForwardNow) {
            String proto;
            if (port.protocol == 17) {
                proto = "UDP";
            } else {
                if (port.protocol != 6) continue;
                proto = "TCP";
            }
            this.removeMapping(proto, port.portNumber, port, false);
        }
    }

    public String getVersion() {
        return Version.getVersion() + " " + Version.getSvnRevision();
    }

    public long getRealVersion() {
        return Version.getRealVersion();
    }

    public static void main(String[] args) throws Exception {
        UPnP upnp = new UPnP();
        ControlPoint cp = new ControlPoint();
        System.out.println("Searching for UPnP devices:");
        cp.start();
        cp.search();
        while (true) {
            DeviceList list = cp.getDeviceList();
            System.out.println("Found " + list.size() + " devices!");
            StringBuilder sb = new StringBuilder();
            for (Device device : list) {
                upnp.listSubDev(device.toString(), device, sb);
                System.out.println("Here is the listing for " + device.toString() + ":");
                System.out.println(sb.toString());
                sb = new StringBuilder();
            }
            System.out.println("End");
            Thread.sleep(2000L);
        }
    }
}

