/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.util;

import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeLiteral<T>
implements Serializable {
    private transient Type actualType;

    protected TypeLiteral() {
    }

    public final Type getType() {
        if (this.actualType == null) {
            Class<?> clazz = TypeLiteral.getTypeLiteralSubclass(this.getClass());
            if (clazz == null) {
                throw new RuntimeException(this.getClass() + " is not a subclass of TypeLiteral");
            }
            this.actualType = TypeLiteral.getTypeParameter(clazz);
            if (this.actualType == null) {
                throw new RuntimeException(this.getClass() + " does not specify the type parameter T of TypeLiteral<T>");
            }
        }
        return this.actualType;
    }

    public final Class<T> getRawType() {
        Type type = this.getType();
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            return Object[].class;
        }
        throw new RuntimeException("Illegal type");
    }

    private static Class<?> getTypeLiteralSubclass(Class<?> clazz) {
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2.equals(TypeLiteral.class)) {
            return clazz;
        }
        if (clazz2.equals(Object.class)) {
            return null;
        }
        return TypeLiteral.getTypeLiteralSubclass(clazz2);
    }

    private static Type getTypeParameter(Class<?> clazz) {
        ParameterizedType parameterizedType;
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getActualTypeArguments().length == 1) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof TypeLiteral) {
            TypeLiteral typeLiteral = (TypeLiteral)object;
            return this.getType().equals(typeLiteral.getType());
        }
        return false;
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public String toString() {
        return this.getType().toString();
    }
}

